package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.CainiaoCrmOmsRuleSyncResponse;

/**
 * TOP API: cainiao.crm.oms.rule.sync request
 * 
 * @author top auto create
 * @since 1.0, 2025.03.26
 */
public class CainiaoCrmOmsRuleSyncRequest extends BaseTaobaoRequest<CainiaoCrmOmsRuleSyncResponse> {
	
	

	/** 
	* 人工审单规则描述
	 */
	private String checkRuleMsg;

	/** 
	* 是否系统智能处理订单（无人工介入）
	 */
	private Boolean isAutoCheck;

	/** 
	* 是否开启菜鸟自动流转规则
	 */
	private Boolean isOpenCnauto;

	/** 
	* 是否开启了订单合单
	 */
	private Boolean isSysMergeOrder;

	/** 
	* 订单合单周期（单位：分钟）
	 */
	private Long mergeOrderCycle;

	/** 
	* 其他未定义订单处理规则，格式｛name;stauts;cycle;｝
	 */
	private String otherRule;

	/** 
	* 店铺nick
	 */
	private String shopCode;

	public void setCheckRuleMsg(String checkRuleMsg) {
		this.checkRuleMsg = checkRuleMsg;
	}

	public String getCheckRuleMsg() {
		return this.checkRuleMsg;
	}

	public void setIsAutoCheck(Boolean isAutoCheck) {
		this.isAutoCheck = isAutoCheck;
	}

	public Boolean getIsAutoCheck() {
		return this.isAutoCheck;
	}

	public void setIsOpenCnauto(Boolean isOpenCnauto) {
		this.isOpenCnauto = isOpenCnauto;
	}

	public Boolean getIsOpenCnauto() {
		return this.isOpenCnauto;
	}

	public void setIsSysMergeOrder(Boolean isSysMergeOrder) {
		this.isSysMergeOrder = isSysMergeOrder;
	}

	public Boolean getIsSysMergeOrder() {
		return this.isSysMergeOrder;
	}

	public void setMergeOrderCycle(Long mergeOrderCycle) {
		this.mergeOrderCycle = mergeOrderCycle;
	}

	public Long getMergeOrderCycle() {
		return this.mergeOrderCycle;
	}

	public void setOtherRule(String otherRule) {
		this.otherRule = otherRule;
	}

	public String getOtherRule() {
		return this.otherRule;
	}

	public void setShopCode(String shopCode) {
		this.shopCode = shopCode;
	}

	public String getShopCode() {
		return this.shopCode;
	}

	public String getApiMethodName() {
		return "cainiao.crm.oms.rule.sync";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("check_rule_msg", this.checkRuleMsg);
		txtParams.put("is_auto_check", this.isAutoCheck);
		txtParams.put("is_open_cnauto", this.isOpenCnauto);
		txtParams.put("is_sys_merge_order", this.isSysMergeOrder);
		txtParams.put("merge_order_cycle", this.mergeOrderCycle);
		txtParams.put("other_rule", this.otherRule);
		txtParams.put("shop_code", this.shopCode);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<CainiaoCrmOmsRuleSyncResponse> getResponseClass() {
		return CainiaoCrmOmsRuleSyncResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(isAutoCheck, "isAutoCheck");
		RequestCheckUtils.checkNotEmpty(isOpenCnauto, "isOpenCnauto");
		RequestCheckUtils.checkNotEmpty(shopCode, "shopCode");
	}
	

}