package com.elitesland.yst.wms.connector.constant;

/**
 * @author : chen.niu
 * @description :
 * @date : 2025/5/15 17:10
 */
import com.elitescloud.cloudt.system.vo.DprUdcVO;
import java.util.ArrayList;
import java.util.List;

public interface BasicWmsUdcEnumInterface {

    DprUdcVO getUdcVO();
    String getValueDescription();

    // 通用UDC构造方法
    default DprUdcVO newUdcVo(String domainCode, String udcCode, String udcName,
                              String description, int sortNo, String valueName) {
        DprUdcVO dprUdcVO = new DprUdcVO();
        dprUdcVO.setDomainCode(domainCode);
        dprUdcVO.setUdcCode(udcCode);
        dprUdcVO.setUdcName(udcName);
        dprUdcVO.setUdcVal(valueName);
        dprUdcVO.setValDesc(description);
        dprUdcVO.setValSortNo(sortNo);
        dprUdcVO.setId((long) sortNo);
        return dprUdcVO;
    }

    // 通用工具方法
    static <E extends Enum<E> & BasicWmsUdcEnumInterface> List<DprUdcVO> getUdcList(Class<E> enumType) {
        List<DprUdcVO> list = new ArrayList<>();
        for (E e : enumType.getEnumConstants()) {
            list.add(e.getUdcVO());
        }
        return list;
    }

    static <E extends Enum<E> & BasicWmsUdcEnumInterface> String getDescription(Class<E> enumType, String key) {
        for (E e : enumType.getEnumConstants()) {
            if (e.name().equals(key)) {
                return e.getValueDescription();
            }
        }
        return null;
    }
}