/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.api.internal.toplink.endpoint;

import com.taobao.api.internal.toplink.channel.ChannelException;
import com.taobao.api.internal.toplink.channel.ChannelSender;
import com.taobao.api.internal.toplink.channel.ClientChannel;
import com.taobao.api.internal.toplink.channel.ServerChannelSender;
import java.net.SocketAddress;
import java.nio.ByteBuffer;

public class ChannelSenderWrapper
implements ChannelSender {
    private ChannelSender sender;
    private int protocolVersion;

    public ChannelSenderWrapper(ChannelSender sender, int protocolVersion) {
        this.sender = sender;
        this.protocolVersion = protocolVersion;
    }

    public int getProtocolVersion() {
        return this.protocolVersion;
    }

    public ChannelSender getChannelSender() {
        return this.sender;
    }

    public boolean isValid() {
        return this.sender instanceof ClientChannel && ((ClientChannel)this.sender).isConnected() || this.sender instanceof ServerChannelSender && ((ServerChannelSender)this.sender).isOpen();
    }

    @Override
    public void send(byte[] data, int offset, int length) throws ChannelException {
        this.sender.send(data, offset, length);
    }

    @Override
    public void send(ByteBuffer dataBuffer, ChannelSender.SendHandler sendHandler) throws ChannelException {
        this.sender.send(dataBuffer, sendHandler);
    }

    @Override
    public void close(String reason) {
        this.sender.close(reason);
    }

    @Override
    public SocketAddress getLocalAddress() {
        return this.sender.getLocalAddress();
    }

    @Override
    public SocketAddress getRemoteAddress() {
        return this.sender.getRemoteAddress();
    }

    @Override
    public Object getContext(Object key) {
        return this.sender.getContext(key);
    }

    @Override
    public void setContext(Object key, Object value) {
        this.sender.setContext(key, value);
    }
}

