/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.inv.rpc.util;

import com.elitesland.yst.inv.rpc.util.HepRedisHashingUtils;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.springframework.stereotype.Component;

@Component
public class HepRedisHashWheel<T> {
    private TreeMap<Long, T> nodes;
    private Map<String, T> hotspots;
    private int virtualNodeCount = 150;

    private void init() {
        this.nodes = new TreeMap();
        this.hotspots.forEach((key, value) -> {
            for (int n = 0; n < this.virtualNodeCount; ++n) {
                this.nodes.put(HepRedisHashingUtils.hash("hotspot-" + key + "-node-" + n), value);
            }
        });
    }

    public T getHotspotsInfo(String key) {
        SortedMap<Long, T> tail = this.nodes.tailMap(HepRedisHashingUtils.hash(key));
        if (tail.size() == 0) {
            return this.nodes.get(this.nodes.firstKey());
        }
        return (T)tail.get(tail.firstKey());
    }

    public void setHotspots(Map<String, T> hotspots) {
        this.hotspots = hotspots;
    }

    public TreeMap<Long, T> getNodes() {
        return this.nodes;
    }

    public Map<String, T> getHotspots() {
        return this.hotspots;
    }

    public int getVirtualNodeCount() {
        return this.virtualNodeCount;
    }

    public void setNodes(TreeMap<Long, T> nodes) {
        this.nodes = nodes;
    }

    public void setVirtualNodeCount(int virtualNodeCount) {
        this.virtualNodeCount = virtualNodeCount;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HepRedisHashWheel)) {
            return false;
        }
        HepRedisHashWheel other = (HepRedisHashWheel)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getVirtualNodeCount() != other.getVirtualNodeCount()) {
            return false;
        }
        TreeMap<Long, T> this$nodes = this.getNodes();
        TreeMap<Long, T> other$nodes = other.getNodes();
        if (this$nodes == null ? other$nodes != null : !((Object)this$nodes).equals(other$nodes)) {
            return false;
        }
        Map<String, T> this$hotspots = this.getHotspots();
        Map<String, T> other$hotspots = other.getHotspots();
        return !(this$hotspots == null ? other$hotspots != null : !((Object)this$hotspots).equals(other$hotspots));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HepRedisHashWheel;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getVirtualNodeCount();
        TreeMap<Long, T> $nodes = this.getNodes();
        result = result * 59 + ($nodes == null ? 43 : ((Object)$nodes).hashCode());
        Map<String, T> $hotspots = this.getHotspots();
        result = result * 59 + ($hotspots == null ? 43 : ((Object)$hotspots).hashCode());
        return result;
    }

    public String toString() {
        return "HepRedisHashWheel(nodes=" + this.getNodes() + ", hotspots=" + this.getHotspots() + ", virtualNodeCount=" + this.getVirtualNodeCount() + ")";
    }
}

