package com.elitesland.zhiyuan.openapi.outer.jggyun.params;

import lombok.Data;
import org.springframework.util.Assert;

import java.util.List;
import java.util.Map;

// ================== 请求类定义 ==================
/**
 * 商品更新请求类
 */
@Data
public  class UpdateGoodsRequest {
    private List<Item> items;
    @Data
    public  class Item {
        // 必填字段
        private String skuId;       // 商品编码
        private String iId;         // 款式编码
        private String name;        // 名称

        // 可选字段
        private String brand;       // 品牌
        private String vcName;      // 虚拟分类
        private String cName;       // 商品分类
        private Double sPrice;      // 基本售价
        private String itemType;    // 商品属性
        private Double l;           // 长
        private Double w;           // 宽
        private Double h;           // 高
        private String pic;         // 款图片
        private String picBig;      // 大图
        private String skuPic;      // SKU图片
        private String remark;      // 备注
        private String propertiesValue; // 颜色规格
        private String shortName;   // 简称
        private Double weight;      // 重量
        private Integer enabled;    // 是否启用
        private String supplierName; // 供应商
        private String skuCode;     // 国标码
        private String supplierSkuId; // 供应商商品编码
        private String supplierIId;  // 供应商款式编码
        private Double otherPrice1; // 其他价格1
        private Double otherPrice2; // 其他价格2
        private Double otherPrice3; // 其他价格3
        private Double otherPrice4; // 其他价格4
        private Double otherPrice5; // 其他价格5
        private String other1;      // 其他属性1
        private String other2;      // 其他属性2
        private String other3;      // 其他属性3
        private String other4;      // 其他属性4
        private String other5;      // 其他属性5
        private Boolean stockDisabled; // 是否禁止同步
        private Double cPrice;      // 成本价
        private Double marketPrice; // 市场价
        private String unit;        // 单位
        private List<String> labels; // 标签
        private Boolean batchEnabled; // 是否启用生产批次
        private Boolean isSeriesNumber; // 是否启用序列号
        private String otherCode;   // 辅助码
        private Integer shelfLife;  // 保质期天数
        private Integer handDay;    // 临期天数
        private Integer rejectLifecycle; // 保质期禁收天数
        private Integer lockupLifecycle; // 保质期禁售天数
        private Integer adventLifecycle; // 保质期预警天数
        private Map<String, String> categoryPropertys; // 自定义属性
        private String productionLicence; // 生产许可证

        // 必填字段校验
        public void validate() {
            Assert.notNull(skuId, "sku_id 必填且非空");
            Assert.notNull(iId, "i_id 必填且非空");
            Assert.notNull(name, "name 必填且非空");
            Assert.notNull(shelfLife, "shelf_life 必须大于0");
            Assert.isTrue(shelfLife > 0, "shelf_life 必须大于0");
        }

    }

    public List<Item> getItems() {
        return items;
    }

    public void setItems(List<Item> items) {
        this.items = items;
    }

}


