/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.zhiyuan.openapi.outer.jushuitan.service.impl;

import com.alibaba.fastjson.JSON;
import com.elitescloud.cloudt.sys.outlog.param.PushRecordDTO;
import com.elitescloud.cloudt.sys.outlog.rpc.OutsidePushRecordRepository;
import com.elitesland.zhiyuan.openapi.outer.jggyun.params.SupplierRequest;
import com.elitesland.zhiyuan.openapi.outer.jggyun.params.UpdateGoodsRequest;
import com.elitesland.zhiyuan.openapi.outer.jggyun.result.UpdateGoodsResponse;
import com.elitesland.zhiyuan.openapi.outer.jushuitan.service.JushuitaService;
import com.elitesland.zhiyuan.openapi.outer.jushuitan.util.NotaoUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@RefreshScope
public class JushuitaServiceImpl
implements JushuitaService {
    private static final Logger log = LoggerFactory.getLogger(JushuitaServiceImpl.class);
    private final OutsidePushRecordRepository outsidePushRecordRepository;

    @Override
    @Transactional
    public String createMaterial(UpdateGoodsRequest request) throws Exception {
        log.info("\u805a\u6c34\u6f6d\u7269\u6599\u63a5\u53e3 \u67e5\u8be2\u5165\u53c2\uff1a" + JSON.toJSONString((Object)request));
        Map<String, Object> itemMap = this.buildItemMap(request);
        HashMap<String, List<Map<String, Object>>> requestMap = new HashMap<String, List<Map<String, Object>>>();
        PushRecordDTO pushRecordDTO = new PushRecordDTO();
        pushRecordDTO.setInterType("JST");
        pushRecordDTO.setDocNo("");
        pushRecordDTO.setDocId(Long.valueOf(0L));
        pushRecordDTO.setReqSuccess(false);
        requestMap.put("items", Collections.singletonList(itemMap));
        String json = JSON.toJSONString(requestMap);
        pushRecordDTO.setReqBody(requestMap);
        String response = NotaoUtil.getSellerItem(json, "/open/jushuitan/itemsku/upload");
        if (response != null) {
            UpdateGoodsResponse response1 = (UpdateGoodsResponse)JSON.parseObject((String)response, UpdateGoodsResponse.class);
            if (response1.getData() != null && response1.getData().getDatas() != null) {
                for (UpdateGoodsResponse.Datas data : response1.getData().getDatas()) {
                    pushRecordDTO.setReqSuccess(data.isSuccess());
                }
            }
            pushRecordDTO.setRespBody((Object)response);
        } else {
            System.out.println("API\u8bf7\u6c42\u8fd4\u56de\u4e3a\u7a7a");
        }
        this.outsidePushRecordRepository.savePushRecord(pushRecordDTO);
        log.info("\u805a\u6c34\u6f6d\u7269\u6599\u63a5\u53e3 \u67e5\u8be2\u7ed3\u679c\uff1a" + JSON.toJSONString((Object)response));
        return response;
    }

    private Map<String, Object> buildItemMap(UpdateGoodsRequest request) {
        HashMap<String, Object> itemMap = new HashMap<String, Object>();
        itemMap.put("sku_id", request.getItems().get(0).getSkuId());
        itemMap.put("i_id", request.getItems().get(0).getIId());
        itemMap.put("name", request.getItems().get(0).getName());
        return itemMap;
    }

    @Override
    @Transactional
    public String syncSupp(SupplierRequest request) throws Exception {
        log.info("\u805a\u6c34\u6f6d\u4f9b\u5e94\u5546\u540c\u6b65\u63a5\u53e3 - \u8bf7\u6c42\u5165\u53c2: {}", (Object)JSON.toJSONString((Object)request));
        try {
            ArrayList<Map<String, Object>> suppliers = new ArrayList<Map<String, Object>>();
            for (SupplierRequest.SupplierItem item : request.getSuppliers()) {
                suppliers.add(this.buildSupplierItemMap(item));
            }
            String jsonRequest = JSON.toJSONString(suppliers);
            log.info("\u805a\u6c34\u6f6d\u4f9b\u5e94\u5546\u540c\u6b65\u63a5\u53e3 - \u53d1\u9001\u6570\u636e: {}", (Object)jsonRequest);
            PushRecordDTO pushRecordDTO = new PushRecordDTO();
            pushRecordDTO.setInterType("JST");
            pushRecordDTO.setDocNo("");
            pushRecordDTO.setDocId(Long.valueOf(0L));
            pushRecordDTO.setReqSuccess(false);
            pushRecordDTO.setReqBody((Object)request);
            String response = NotaoUtil.getSellerItem(jsonRequest, "/open/supplier/upload");
            if (response != null) {
                UpdateGoodsResponse response1 = (UpdateGoodsResponse)JSON.parseObject((String)response, UpdateGoodsResponse.class);
                if (response1.getData() != null && response1.getData().getDatas() != null) {
                    for (UpdateGoodsResponse.Datas data : response1.getData().getDatas()) {
                        pushRecordDTO.setReqSuccess(data.isSuccess());
                    }
                }
                pushRecordDTO.setRespBody((Object)response);
            } else {
                System.out.println("API\u8bf7\u6c42\u8fd4\u56de\u4e3a\u7a7a");
            }
            this.outsidePushRecordRepository.savePushRecord(pushRecordDTO);
            return response;
        }
        catch (Exception e) {
            log.error("\u805a\u6c34\u6f6d\u4f9b\u5e94\u5546\u540c\u6b65\u63a5\u53e3\u8c03\u7528\u53d1\u751f\u5f02\u5e38", (Throwable)e);
            throw new Exception("\u8c03\u7528\u805a\u6c34\u6f6d\u4f9b\u5e94\u5546\u540c\u6b65\u63a5\u53e3\u5931\u8d25: " + e.getMessage(), e);
        }
    }

    private Map<String, Object> buildSupplierItemMap(SupplierRequest.SupplierItem item) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("supplier_code", item.getSupplier_code());
        map.put("name", item.getName());
        map.put("enabled", true);
        return map;
    }

    public JushuitaServiceImpl(OutsidePushRecordRepository outsidePushRecordRepository) {
        this.outsidePushRecordRepository = outsidePushRecordRepository;
    }
}

