package com.elitesland.zhiyuan.openapi.outer.jackyun.util;

import java.security.MessageDigest;

/**
 * 辅助类
 *
 * @author hup
 * @data 2020-06-01 16:55
 **/
public class CoreUtils {
    /**
     * MD5加密工具类
     *
     * @param data 需要加密的数据
     * @return 加密后数据
     */
    public static String makeMD5(String data) throws Exception {
        return makeMD5(data, "UTF-8");
    }

    /**
     * MD5加密工具类
     *
     * @param data     需要加密的数据
     * @param encoding 编码格式
     * @return 加密后数据
     */
    public static String makeMD5(String data, String encoding) throws Exception {
        return encrypt(data, encoding);
    }

    /**
     * 加密
     *
     * @param text     原文本
     * @param encoding 编码格式
     * @return 加密后的文本
     */
    public static String encrypt(String text, String encoding) throws Exception {
        if (encoding == null || encoding.isEmpty()) {
            encoding = "UTF-8";
        }
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        byte[] resultByte = text.getBytes(encoding);
        byte[] md5Bytes = md5.digest(resultByte);
        StringBuilder hexValue = new StringBuilder();
        for (byte md5Byte : md5Bytes) {
            int val = (md5Byte) & 0xff;
            if (val < 16) {
                hexValue.append("0");
            }
            hexValue.append(Integer.toHexString(val));
        }
        return hexValue.toString();
    }


}
