/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.zhiyuan.openapi.outer.jackyun.service.impl;

import com.elitescloud.cloudt.sys.outlog.param.PushRecordDTO;
import com.elitescloud.cloudt.sys.outlog.rpc.OutsidePushRecordRepository;
import com.elitesland.zhiyuan.openapi.outer.jackyun.client.GikyCloudClient;
import com.elitesland.zhiyuan.openapi.outer.jackyun.client.JackyunOpenHttpUtils;
import com.elitesland.zhiyuan.openapi.outer.jackyun.params.ErpGoodsSkuimPortBatchRequestBizData;
import com.elitesland.zhiyuan.openapi.outer.jackyun.params.ErpVendCreateV2RequestBizData;
import com.elitesland.zhiyuan.openapi.outer.jackyun.params.MaterialCreateRequest;
import com.elitesland.zhiyuan.openapi.outer.jackyun.params.VendCreateRequest;
import com.elitesland.zhiyuan.openapi.outer.jackyun.service.JackyunService;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@RefreshScope
public class JackyunServiceImpl
implements JackyunService {
    private static final Logger log = LoggerFactory.getLogger(JackyunServiceImpl.class);
    @Autowired
    private GikyCloudClient gikyCloudClient;
    private final OutsidePushRecordRepository outsidePushRecordRepository;
    @Autowired
    private ObjectMapper objectMapper;

    @Override
    @Transactional
    public String createMaterial(MaterialCreateRequest request) throws Exception {
        if (StringUtils.isBlank((CharSequence)request.getGoodsNo())) {
            throw new IllegalArgumentException("\u8d27\u54c1\u7f16\u7801 goodsNo \u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)request.getGoodsName())) {
            throw new IllegalArgumentException("\u8d27\u54c1\u540d\u79f0 goodsName \u4e0d\u80fd\u4e3a\u7a7a");
        }
        ErpGoodsSkuimPortBatchRequestBizData erpbizData = new ErpGoodsSkuimPortBatchRequestBizData();
        erpbizData.setGoodsNo(request.getGoodsNo());
        erpbizData.setGoodsName(request.getGoodsName());
        erpbizData.setOutSkuCode(request.getGoodsNo());
        return this.parseGikyResponse(JackyunOpenHttpUtils.post("erp.goods.skuimportbatch", "v1.0", null, erpbizData));
    }

    private String parseGikyResponse(String responseStr) throws Exception {
        PushRecordDTO pushRecordDTO = new PushRecordDTO();
        pushRecordDTO.setInterType("JKY");
        pushRecordDTO.setDocNo("");
        pushRecordDTO.setDocId(Long.valueOf(0L));
        pushRecordDTO.setReqSuccess(false);
        pushRecordDTO.setRespBody((Object)responseStr);
        this.outsidePushRecordRepository.savePushRecord(pushRecordDTO);
        return "materId";
    }

    @Override
    @Transactional
    public String createVendor(VendCreateRequest request) throws Exception {
        request.validate();
        ErpVendCreateV2RequestBizData erpbizData = new ErpVendCreateV2RequestBizData();
        erpbizData.setCode(request.getCode());
        erpbizData.setName(request.getName());
        return this.parseSuppGikyResponse(JackyunOpenHttpUtils.post("erp.vend.create.v2", "v1.0", null, erpbizData));
    }

    private String parseSuppGikyResponse(String responseStr) throws Exception {
        PushRecordDTO pushRecordDTO = new PushRecordDTO();
        pushRecordDTO.setInterType("JKY");
        pushRecordDTO.setDocNo("");
        pushRecordDTO.setDocId(Long.valueOf(0L));
        pushRecordDTO.setReqSuccess(true);
        pushRecordDTO.setRespBody((Object)responseStr);
        this.outsidePushRecordRepository.savePushRecord(pushRecordDTO);
        return "vendId";
    }

    public JackyunServiceImpl(OutsidePushRecordRepository outsidePushRecordRepository) {
        this.outsidePushRecordRepository = outsidePushRecordRepository;
    }
}

