/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.zhiyuan.openapi.outer.jackyun.client;

import com.elitesland.zhiyuan.openapi.outer.jackyun.params.BaseRequestBizData;
import com.elitesland.zhiyuan.openapi.outer.jackyun.util.JsonUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import java.util.TreeMap;

public class JackyunOpenHttpUtils {
    private static final String APPKEY = "10526885";
    private static final String APPSECRET = "81c0332dc7a94e168504a3c866f79043";
    private static final String GATEWAY = "https://open.jackyun.com/open/openapi/do";
    private static final DateTimeFormatter DEFAULT_DATETIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private static final String STR_UFT8 = "UTF-8";
    private static final String BIZCONTENT = "bizcontent";

    public static String post(String method, String version, String token, BaseRequestBizData bizData) throws Exception {
        TreeMap<String, String> sortedMap = new TreeMap<String, String>();
        sortedMap.put("method", method);
        sortedMap.put("appkey", APPKEY);
        sortedMap.put("version", version);
        sortedMap.put("contenttype", "json");
        sortedMap.put("timestamp", DEFAULT_DATETIME_FORMATTER.format(LocalDateTime.now()));
        sortedMap.put(BIZCONTENT, JsonUtils.toJson(bizData));
        StringBuilder sbSignData = new StringBuilder(APPSECRET);
        for (Map.Entry entry : sortedMap.entrySet()) {
            sbSignData.append((String)entry.getKey()).append((String)entry.getValue());
        }
        sbSignData.append(APPSECRET);
        sortedMap.put("sign", JackyunOpenHttpUtils.md5Encrypt(sbSignData.toString().toLowerCase(), STR_UFT8));
        if (token != null && !token.isEmpty()) {
            sortedMap.put("token", token);
        }
        StringBuilder sbPostData = new StringBuilder();
        for (Map.Entry entry : sortedMap.entrySet()) {
            if (BIZCONTENT.equalsIgnoreCase((String)entry.getKey())) {
                sbPostData.append("&").append((String)entry.getKey()).append("=").append(URLEncoder.encode((String)entry.getValue(), STR_UFT8));
                continue;
            }
            sbPostData.append("&").append((String)entry.getKey()).append("=").append((String)entry.getValue());
        }
        String string = sbPostData.substring(1);
        return JackyunOpenHttpUtils.postData(GATEWAY, string);
    }

    private static String md5Encrypt(String text, String encoding) throws Exception {
        if (encoding == null || encoding.isEmpty()) {
            encoding = STR_UFT8;
        }
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        byte[] resultByte = text.getBytes(encoding);
        byte[] md5Bytes = md5.digest(resultByte);
        StringBuilder hexValue = new StringBuilder();
        for (byte md5Byte : md5Bytes) {
            int val = md5Byte & 0xFF;
            if (val < 16) {
                hexValue.append("0");
            }
            hexValue.append(Integer.toHexString(val));
        }
        return hexValue.toString();
    }

    public static String postData(String url, String postData) throws IOException {
        return JackyunOpenHttpUtils.postData(url, postData, STR_UFT8, 300000);
    }

    public static String postData(String url, String postData, String encoding) throws IOException {
        return JackyunOpenHttpUtils.postData(url, postData, encoding, 300000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String postData(String url, String postData, String encoding, int timeOut) throws IOException {
        if (encoding == null || encoding.isEmpty()) {
            encoding = STR_UFT8;
        }
        if (timeOut <= 0) {
            timeOut = 300000;
        }
        PrintWriter printWriter = null;
        BufferedReader bufferedReader = null;
        StringBuffer resultBuffer = null;
        URLConnection urlConnection = null;
        try {
            URL postMethodUrl = new URL(url);
            urlConnection = postMethodUrl.openConnection();
            urlConnection.setRequestProperty("accept", "*/*");
            urlConnection.setRequestProperty("connection", "Keep-Alive");
            urlConnection.setRequestProperty("user-agent", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1;SV1)");
            urlConnection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            urlConnection.setConnectTimeout(timeOut);
            urlConnection.setDoOutput(true);
            urlConnection.setDoInput(true);
            urlConnection.setRequestProperty("Charset", encoding);
            printWriter = new PrintWriter(urlConnection.getOutputStream());
            printWriter.print(postData);
            printWriter.flush();
            bufferedReader = new BufferedReader(new InputStreamReader(urlConnection.getInputStream()));
            resultBuffer = new StringBuffer();
            String temp = "";
            while ((temp = bufferedReader.readLine()) != null) {
                resultBuffer.append(temp);
            }
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (printWriter != null) {
                try {
                    printWriter.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return resultBuffer.toString();
    }
}

