/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.zhiyuan.openapi.outer.jackyun.service.impl;

import com.elitescloud.cloudt.sys.outlog.param.PushRecordDTO;
import com.elitescloud.cloudt.sys.outlog.rpc.OutsidePushRecordRepository;
import com.elitesland.zhiyuan.openapi.outer.jackyun.client.GikyCloudClient;
import com.elitesland.zhiyuan.openapi.outer.jackyun.client.JackyunOpenHttpUtils;
import com.elitesland.zhiyuan.openapi.outer.jackyun.params.ErpGoodsSkuimPortBatchRequestBizData;
import com.elitesland.zhiyuan.openapi.outer.jackyun.params.ErpVendCreateV2RequestBizData;
import com.elitesland.zhiyuan.openapi.outer.jackyun.params.MaterialCreateRequest;
import com.elitesland.zhiyuan.openapi.outer.jackyun.params.VendCreateRequest;
import com.elitesland.zhiyuan.openapi.outer.jackyun.service.JackyunService;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@RefreshScope
public class JackyunServiceImpl
implements JackyunService {
    private static final Logger log = LoggerFactory.getLogger(JackyunServiceImpl.class);
    @Autowired
    private GikyCloudClient gikyCloudClient;
    private final OutsidePushRecordRepository outsidePushRecordRepository;
    @Autowired
    private ObjectMapper objectMapper;

    @Override
    @Transactional
    public String createMaterial(MaterialCreateRequest request) throws Exception {
        try {
            log.info("\u5f00\u59cb\u521b\u5efa\u7269\u6599\uff0c\u8bf7\u6c42\u53c2\u6570: [goodsNo={}] [goodsName={}]", (Object)request.getGoodsNo(), (Object)request.getGoodsName());
            if (StringUtils.isBlank((CharSequence)request.getGoodsNo())) {
                throw new IllegalArgumentException("\u8d27\u54c1\u7f16\u7801 goodsNo \u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)request.getGoodsName())) {
                throw new IllegalArgumentException("\u8d27\u54c1\u540d\u79f0 goodsName \u4e0d\u80fd\u4e3a\u7a7a");
            }
            ErpGoodsSkuimPortBatchRequestBizData erpbizData = new ErpGoodsSkuimPortBatchRequestBizData();
            erpbizData.setGoodsNo(request.getGoodsNo());
            erpbizData.setGoodsName(request.getGoodsName());
            erpbizData.setOutSkuCode(request.getGoodsNo());
            String responseStr = JackyunOpenHttpUtils.post("erp.goods.skuimportbatch", "v1.0", null, erpbizData);
            log.debug("\u7269\u6599\u521b\u5efa\u63a5\u53e3\u8c03\u7528\u6210\u529f\uff0c\u8bf7\u6c42\u53c2\u6570: [{}], \u54cd\u5e94\u5185\u5bb9: [{}]", (Object)erpbizData, (Object)responseStr);
            return this.parseGikyResponse(responseStr, "createMaterial", request.getGoodsNo());
        }
        catch (Exception e) {
            log.error("\u7269\u6599\u521b\u5efa\u5931\u8d25\uff0c\u8bf7\u6c42\u53c2\u6570: [goodsNo={}] [goodsName={}]", new Object[]{request.getGoodsNo(), request.getGoodsName(), e});
            throw e;
        }
    }

    @Override
    @Transactional
    public String createVendor(VendCreateRequest request) throws Exception {
        try {
            log.info("\u5f00\u59cb\u521b\u5efa\u4f9b\u5e94\u5546\uff0c\u8bf7\u6c42\u53c2\u6570: [code={}] [name={}]", (Object)request.getCode(), (Object)request.getName());
            request.validate();
            ErpVendCreateV2RequestBizData erpbizData = new ErpVendCreateV2RequestBizData();
            erpbizData.setCode(request.getCode());
            erpbizData.setName(request.getName());
            String responseStr = JackyunOpenHttpUtils.post("erp.vend.create.v2", "v1.0", null, erpbizData);
            log.debug("\u4f9b\u5e94\u5546\u521b\u5efa\u63a5\u53e3\u8c03\u7528\u6210\u529f\uff0c\u8bf7\u6c42\u53c2\u6570: [{}], \u54cd\u5e94\u5185\u5bb9: [{}]", (Object)erpbizData, (Object)responseStr);
            return this.parseSuppGikyResponse(responseStr, "createVendor", request.getCode());
        }
        catch (Exception e) {
            log.error("\u4f9b\u5e94\u5546\u521b\u5efa\u5931\u8d25\uff0c\u8bf7\u6c42\u53c2\u6570: [code={}] [name={}]", new Object[]{request.getCode(), request.getName(), e});
            throw e;
        }
    }

    private String parseGikyResponse(String responseStr, String method, String goodsNo) {
        PushRecordDTO pushRecordDTO = new PushRecordDTO();
        pushRecordDTO.setInterType("JKY");
        pushRecordDTO.setDocNo(goodsNo);
        pushRecordDTO.setDocId(Long.valueOf(0L));
        pushRecordDTO.setReqSuccess(true);
        pushRecordDTO.setRespBody((Object)responseStr);
        try {
            log.debug("\u7269\u6599\u521b\u5efa\u65e5\u5fd7\u8bb0\u5f55\u6210\u529f\uff0c\u7269\u6599\u7f16\u7801: {}", (Object)goodsNo);
            this.outsidePushRecordRepository.savePushRecord(pushRecordDTO);
            return "materId";
        }
        catch (Exception e) {
            pushRecordDTO.setErrorMsg(e.getMessage());
            pushRecordDTO.setReqSuccess(false);
            log.error("\u7269\u6599\u521b\u5efa\u65e5\u5fd7\u8bb0\u5f55\u5931\u8d25\uff0c\u7269\u6599\u7f16\u7801: {}, \u54cd\u5e94\u5185\u5bb9: {}", new Object[]{goodsNo, responseStr, e});
            return "materId";
        }
    }

    private String parseSuppGikyResponse(String responseStr, String method, String code) {
        PushRecordDTO pushRecordDTO = new PushRecordDTO();
        pushRecordDTO.setInterType("JST");
        pushRecordDTO.setDocNo(code);
        pushRecordDTO.setDocId(Long.valueOf(0L));
        pushRecordDTO.setReqSuccess(true);
        pushRecordDTO.setRespBody((Object)responseStr);
        try {
            this.outsidePushRecordRepository.savePushRecord(pushRecordDTO);
            log.debug("\u4f9b\u5e94\u5546\u521b\u5efa\u65e5\u5fd7\u8bb0\u5f55\u6210\u529f\uff0c\u4f9b\u5e94\u5546\u7f16\u7801: {}", (Object)code);
            return "vendId";
        }
        catch (Exception e) {
            pushRecordDTO.setErrorMsg(e.getMessage());
            pushRecordDTO.setReqSuccess(false);
            log.error("\u4f9b\u5e94\u5546\u521b\u5efa\u65e5\u5fd7\u8bb0\u5f55\u5931\u8d25\uff0c\u4f9b\u5e94\u5546\u7f16\u7801: {}, \u54cd\u5e94\u5185\u5bb9: {}", new Object[]{code, responseStr, e});
            this.outsidePushRecordRepository.savePushRecord(pushRecordDTO);
            return "vendId";
        }
    }

    public JackyunServiceImpl(OutsidePushRecordRepository outsidePushRecordRepository) {
        this.outsidePushRecordRepository = outsidePushRecordRepository;
    }
}

