package com.elitesland.zhiyuan.openapi.outer.nc.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * NC接口响应DTO
 *
 * @author generated
 */
@Data
@ApiModel("NC接口响应DTO")
public class NcResponseDTO implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 账套
     */
    @ApiModelProperty(value = "账套")
    private String account;

    /**
     * 单据类型
     */
    @ApiModelProperty(value = "单据类型")
    private String billtype;

    /**
     * 返回数据
     */
    @ApiModelProperty(value = "返回数据")
    private String data;

    /**
     * 数据类型
     */
    @ApiModelProperty(value = "数据类型")
    private String datatype;

    /**
     * 状态
     * S=成功, F=失败
     */
    @ApiModelProperty(value = "状态", notes = "S=成功, F=失败")
    private String status;

    /**
     * 消息
     */
    @ApiModelProperty(value = "消息")
    private String message;

    /**
     * 动作
     */
    @ApiModelProperty(value = "动作")
    private String action;

    /**
     * 用户ID
     */
    @ApiModelProperty(value = "用户ID")
    private String userid;

    /**
     * 密码
     */
    @ApiModelProperty(value = "密码")
    private String password;

    /**
     * 校验码
     */
    @ApiModelProperty(value = "校验码")
    private String checkcode;

    /**
     * 设备类型
     */
    @ApiModelProperty(value = "设备类型")
    private String devtype;

    /**
     * 设备ID
     */
    @ApiModelProperty(value = "设备ID")
    private String devid;

    /**
     * 判断是否成功
     */
    public boolean isSuccess() {
        return "S".equalsIgnoreCase(status);
    }

    /**
     * 判断是否失败
     */
    public boolean isFailed() {
        return "F".equalsIgnoreCase(status);
    }

    /**
     * 获取错误信息
     */
    public String getErrorMessage() {
        if (isFailed()) {
            return message != null ? message : "NC接口调用失败";
        }
        return null;
    }
}