/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.zhiyuan.openapi.outer.jushuitan.service.impl;

import com.alibaba.fastjson.JSON;
import com.elitescloud.cloudt.sys.outlog.param.PushRecordDTO;
import com.elitescloud.cloudt.sys.outlog.rpc.OutsidePushRecordRepository;
import com.elitesland.zhiyuan.openapi.outer.jggyun.params.SupplierRequest;
import com.elitesland.zhiyuan.openapi.outer.jggyun.params.UpdateGoodsRequest;
import com.elitesland.zhiyuan.openapi.outer.jggyun.result.UpdateGoodsResponse;
import com.elitesland.zhiyuan.openapi.outer.jushuitan.service.JushuitaService;
import com.elitesland.zhiyuan.openapi.outer.jushuitan.util.NotaoUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
@RefreshScope
public class JushuitaServiceImpl
implements JushuitaService {
    private static final Logger log = LoggerFactory.getLogger(JushuitaServiceImpl.class);
    private final OutsidePushRecordRepository outsidePushRecordRepository;

    @Override
    @Transactional
    public String createMaterial(UpdateGoodsRequest request) throws Exception {
        if (request == null || CollectionUtils.isEmpty(request.getItems())) {
            String errorMsg = "createMaterial\u8bf7\u6c42\u53c2\u6570\u4e3a\u7a7a\u6216items\u5217\u8868\u4e3a\u7a7a";
            log.error("\u53c2\u6570\u6821\u9a8c\u5931\u8d25: {}", (Object)errorMsg);
            throw new IllegalArgumentException(errorMsg);
        }
        if (request.getItems().size() > 1) {
            log.warn("createMaterial\u8bf7\u6c42\u5305\u542b{}\u4e2a\u5546\u54c1\uff0c\u4ec5\u5904\u7406\u7b2c\u4e00\u4e2a\u5546\u54c1\u3002\u5efa\u8bae\u6bcf\u6b21\u8bf7\u6c42\u4ec5\u5305\u542b\u4e00\u4e2a\u5546\u54c1", (Object)request.getItems().size());
        }
        log.info("\u805a\u6c34\u6f6d\u7269\u6599\u63a5\u53e3 - \u8bf7\u6c42\u5f00\u59cb | \u5546\u54c1ID: {}, \u8bf7\u6c42\u53c2\u6570: {}", (Object)request.getItems().get(0).getSkuId(), (Object)JSON.toJSONString((Object)request, (boolean)true));
        PushRecordDTO pushRecordDTO = this.buildPushRecordDTO("JST", "createMaterial");
        pushRecordDTO.setReqBody((Object)request);
        try {
            Map<String, Object> itemMap = this.buildItemMap(request);
            Map<String, List<Map<String, Object>>> requestMap = Collections.singletonMap("items", Collections.singletonList(itemMap));
            String jsonRequest = JSON.toJSONString(requestMap);
            log.debug("\u805a\u6c34\u6f6d\u7269\u6599\u63a5\u53e3 - \u8bf7\u6c42\u6570\u636e: {}", (Object)jsonRequest);
            pushRecordDTO.setReqBody(requestMap);
            String response = NotaoUtil.getSellerItem(jsonRequest, "/open/jushuitan/itemsku/upload");
            log.debug("\u805a\u6c34\u6f6d\u7269\u6599\u63a5\u53e3 - \u54cd\u5e94: {}", (Object)response);
            if (response == null) {
                log.error("\u805a\u6c34\u6f6d\u7269\u6599\u63a5\u53e3 - \u54cd\u5e94\u4e3a\u7a7a");
                pushRecordDTO.setReqSuccess(false);
                pushRecordDTO.setErrorMsg("\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a");
                throw new RuntimeException("\u805a\u6c34\u6f6d\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a");
            }
            UpdateGoodsResponse responseObj = (UpdateGoodsResponse)JSON.parseObject((String)response, UpdateGoodsResponse.class);
            boolean success = this.handleResponseData(responseObj, pushRecordDTO);
            pushRecordDTO.setReqSuccess(success);
            this.outsidePushRecordRepository.savePushRecord(pushRecordDTO);
            log.info("\u805a\u6c34\u6f6d\u7269\u6599\u63a5\u53e3 - \u5904\u7406\u5b8c\u6210 | \u5546\u54c1ID: {}, \u54cd\u5e94\u72b6\u6001: {}", (Object)request.getItems().get(0).getSkuId(), (Object)(success ? "\u6210\u529f" : "\u5931\u8d25"));
            return response;
        }
        catch (Exception e) {
            log.error("\u805a\u6c34\u6f6d\u7269\u6599\u63a5\u53e3\u8c03\u7528\u5f02\u5e38 | \u5546\u54c1ID: {}", (Object)request.getItems().get(0).getSkuId(), (Object)e);
            pushRecordDTO.setErrorMsg(e.getMessage());
            pushRecordDTO.setReqSuccess(false);
            this.outsidePushRecordRepository.savePushRecord(pushRecordDTO);
            throw new Exception("\u805a\u6c34\u6f6d\u7269\u6599\u63a5\u53e3\u8c03\u7528\u5931\u8d25: " + e.getMessage(), e);
        }
    }

    private boolean handleResponseData(UpdateGoodsResponse responseObj, PushRecordDTO pushRecordDTO) {
        if (responseObj == null || responseObj.getData() == null || CollectionUtils.isEmpty(responseObj.getData().getDatas())) {
            log.warn("\u805a\u6c34\u6f6d\u7269\u6599\u63a5\u53e3\u54cd\u5e94\u6570\u636e\u4e3a\u7a7a");
            return false;
        }
        boolean success = true;
        ArrayList<String> failedItems = new ArrayList<String>();
        for (UpdateGoodsResponse.Datas data : responseObj.getData().getDatas()) {
            if (data.isSuccess()) continue;
            success = false;
            failedItems.add(data.getSkuId());
        }
        if (!success) {
            log.warn("\u805a\u6c34\u6f6d\u7269\u6599\u63a5\u53e3\u90e8\u5206\u5546\u54c1\u5931\u8d25 | \u5931\u8d25\u5546\u54c1ID: {}", (Object)failedItems.stream().collect(Collectors.joining(",")));
        }
        return success;
    }

    private Map<String, Object> buildItemMap(UpdateGoodsRequest request) {
        UpdateGoodsRequest.Item item = request.getItems().get(0);
        HashMap<String, Object> itemMap = new HashMap<String, Object>();
        if (StringUtils.isEmpty((CharSequence)item.getSkuId()) || StringUtils.isEmpty((CharSequence)item.getIId()) || StringUtils.isEmpty((CharSequence)item.getName())) {
            throw new IllegalArgumentException(String.format("\u7269\u6599\u5fc5\u586b\u5b57\u6bb5\u7f3a\u5931 | skuId: %s, iId: %s, name: %s", item.getSkuId(), item.getIId(), item.getName()));
        }
        itemMap.put("sku_id", item.getSkuId());
        itemMap.put("i_id", item.getIId());
        itemMap.put("name", item.getName());
        return itemMap;
    }

    @Override
    @Transactional
    public String syncSupp(SupplierRequest request) throws Exception {
        if (request == null || CollectionUtils.isEmpty(request.getSuppliers())) {
            String errorMsg = "syncSupp\u8bf7\u6c42\u53c2\u6570\u4e3a\u7a7a\u6216suppliers\u5217\u8868\u4e3a\u7a7a";
            log.error("\u53c2\u6570\u6821\u9a8c\u5931\u8d25: {}", (Object)errorMsg);
            throw new IllegalArgumentException(errorMsg);
        }
        log.info("\u805a\u6c34\u6f6d\u4f9b\u5e94\u5546\u540c\u6b65\u63a5\u53e3 - \u8bf7\u6c42\u5f00\u59cb | \u4f9b\u5e94\u5546\u6570\u91cf: {}", (Object)request.getSuppliers().size());
        PushRecordDTO pushRecordDTO = this.buildPushRecordDTO("JST", "syncSupp");
        pushRecordDTO.setReqBody((Object)request);
        try {
            List suppliers = request.getSuppliers().stream().map(this::buildSupplierItemMap).collect(Collectors.toList());
            String jsonRequest = JSON.toJSONString(suppliers);
            log.debug("\u805a\u6c34\u6f6d\u4f9b\u5e94\u5546\u540c\u6b65\u63a5\u53e3 - \u8bf7\u6c42\u6570\u636e: {}", (Object)jsonRequest);
            pushRecordDTO.setReqBody(suppliers);
            String response = NotaoUtil.getSellerItem(jsonRequest, "/open/supplier/upload");
            log.debug("\u805a\u6c34\u6f6d\u4f9b\u5e94\u5546\u540c\u6b65\u63a5\u53e3 - \u54cd\u5e94: {}", (Object)response);
            if (response == null) {
                log.error("\u805a\u6c34\u6f6d\u4f9b\u5e94\u5546\u540c\u6b65\u63a5\u53e3 - \u54cd\u5e94\u4e3a\u7a7a");
                pushRecordDTO.setReqSuccess(false);
                pushRecordDTO.setErrorMsg("\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a");
                throw new RuntimeException("\u805a\u6c34\u6f6d\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a");
            }
            UpdateGoodsResponse responseObj = (UpdateGoodsResponse)JSON.parseObject((String)response, UpdateGoodsResponse.class);
            boolean success = this.handleResponseData(responseObj, pushRecordDTO);
            pushRecordDTO.setReqSuccess(success);
            this.outsidePushRecordRepository.savePushRecord(pushRecordDTO);
            log.info("\u805a\u6c34\u6f6d\u4f9b\u5e94\u5546\u540c\u6b65\u63a5\u53e3 - \u5904\u7406\u5b8c\u6210 | \u4f9b\u5e94\u5546\u6570\u91cf: {}, \u72b6\u6001: {}", (Object)request.getSuppliers().size(), (Object)(success ? "\u6210\u529f" : "\u5931\u8d25"));
            return response;
        }
        catch (Exception e) {
            log.error("\u805a\u6c34\u6f6d\u4f9b\u5e94\u5546\u540c\u6b65\u63a5\u53e3\u5f02\u5e38 | \u4f9b\u5e94\u5546\u6570\u91cf: {}", (Object)request.getSuppliers().size(), (Object)e);
            pushRecordDTO.setErrorMsg(e.getMessage());
            pushRecordDTO.setReqSuccess(false);
            this.outsidePushRecordRepository.savePushRecord(pushRecordDTO);
            throw new Exception("\u805a\u6c34\u6f6d\u4f9b\u5e94\u5546\u540c\u6b65\u63a5\u53e3\u5931\u8d25: " + e.getMessage(), e);
        }
    }

    private PushRecordDTO buildPushRecordDTO(String interType, String method) {
        PushRecordDTO dto = new PushRecordDTO();
        dto.setInterType(interType);
        dto.setDocNo("");
        dto.setDocId(Long.valueOf(0L));
        dto.setReqSuccess(false);
        return dto;
    }

    private Map<String, Object> buildSupplierItemMap(SupplierRequest.SupplierItem item) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("supplier_code", item.getSupplier_code());
        map.put("name", item.getName());
        map.put("enabled", true);
        return map;
    }

    public JushuitaServiceImpl(OutsidePushRecordRepository outsidePushRecordRepository) {
        this.outsidePushRecordRepository = outsidePushRecordRepository;
    }
}

