/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.zhiyuan.openapi.outer.nc.service.impl;

import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.sys.outlog.param.PushRecordDTO;
import com.elitescloud.cloudt.sys.outlog.rpc.OutsidePushRecordRepository;
import com.elitesland.zhiyuan.openapi.outer.nc.client.NcForestClient;
import com.elitesland.zhiyuan.openapi.outer.nc.config.NcProperties;
import com.elitesland.zhiyuan.openapi.outer.nc.dto.NcRequestDTO;
import com.elitesland.zhiyuan.openapi.outer.nc.dto.NcResponseDTO;
import com.elitesland.zhiyuan.openapi.outer.nc.exception.NcApiException;
import com.elitesland.zhiyuan.openapi.outer.nc.service.NcService;
import com.elitesland.zhiyuan.openapi.outer.nc.util.NcResponseUtil;
import java.security.MessageDigest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
@RefreshScope
public class NcServiceImpl
implements NcService {
    private static final Logger log = LoggerFactory.getLogger(NcServiceImpl.class);
    private final NcProperties ncProperties;
    private final NcForestClient ncForestClient;
    private final OutsidePushRecordRepository outsidePushRecordRepository;

    @Override
    public String test() {
        log.info("ncProperties: {}", (Object)this.ncProperties);
        return "NC Hello, World!";
    }

    @Override
    public NcResponseDTO callNcApiWithForest(NcRequestDTO request) {
        if (!this.ncProperties.getEnabled().booleanValue()) {
            log.warn("NC\u63a5\u53e3\u672a\u542f\u7528\uff0c\u8df3\u8fc7\u8c03\u7528");
            NcResponseDTO response = new NcResponseDTO();
            response.setStatus("F");
            response.setMessage("NC\u63a5\u53e3\u672a\u542f\u7528");
            return response;
        }
        try {
            log.info("Forest\u62e6\u622a\u5668\u65b9\u5f0f\u8c03\u7528NC\u63a5\u53e3");
            log.info("\u8bf7\u6c42\u53c2\u6570: {}", (Object)JSON.toJSONString((Object)request, (boolean)true));
            String responseJson = this.ncForestClient.callNcApi(request);
            log.info("Forest\u63a5\u53e3\u539f\u59cb\u54cd\u5e94: {}", (Object)responseJson);
            NcResponseDTO response = NcResponseUtil.parseAndCheck(responseJson);
            log.info("Forest\u62e6\u622a\u5668\u65b9\u5f0f\u8c03\u7528\u6210\u529f\uff0c\u72b6\u6001: {}", (Object)response.getStatus());
            return response;
        }
        catch (NcApiException e) {
            log.error("NC\u63a5\u53e3\u4e1a\u52a1\u5f02\u5e38: {}", (Object)e.getMessage());
            throw e;
        }
        catch (Exception e) {
            log.error("Forest\u62e6\u622a\u5668\u65b9\u5f0f\u8c03\u7528NC\u63a5\u53e3\u5f02\u5e38", (Throwable)e);
            throw new BusinessException("Forest\u8c03\u7528NC\u63a5\u53e3\u5931\u8d25: " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public NcResponseDTO callNcApiWithForest(NcRequestDTO request, String pushRecordInterType, Long docId, String docNo) {
        Assert.notNull((Object)request, (String)"\u8bf7\u6c42\u4f53\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)pushRecordInterType, (String)"\u63a8\u9001\u8bb0\u5f55\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)docId, (String)"\u63a8\u9001\u5355\u636eID\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)docNo, (String)"\u63a8\u9001\u5355\u636e\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        if (!this.ncProperties.getEnabled().booleanValue()) {
            log.warn("NC\u63a5\u53e3\u672a\u542f\u7528\uff0c\u8df3\u8fc7\u8c03\u7528");
            NcResponseDTO response = new NcResponseDTO();
            response.setStatus("S");
            response.setMessage("NC\u63a5\u53e3\u672a\u542f\u7528");
            return response;
        }
        PushRecordDTO pushRecordDTO = new PushRecordDTO();
        pushRecordDTO.setInterType(pushRecordInterType);
        pushRecordDTO.setDocNo(docNo);
        pushRecordDTO.setDocId(docId);
        pushRecordDTO.setReqSuccess(false);
        pushRecordDTO.setReqBody((Object)request);
        try {
            log.info("Forest\u62e6\u622a\u5668\u65b9\u5f0f\u8c03\u7528NC\u63a5\u53e3");
            log.info("\u8bf7\u6c42\u53c2\u6570: {}", (Object)JSON.toJSONString((Object)request, (boolean)true));
            String responseJson = this.ncForestClient.callNcApi(request);
            log.info("Forest\u63a5\u53e3\u539f\u59cb\u54cd\u5e94: {}", (Object)responseJson);
            NcResponseDTO response = NcResponseUtil.parseAndCheck(responseJson);
            pushRecordDTO.setRespBody((Object)response);
            if (!response.isSuccess()) {
                pushRecordDTO.setErrorMsg(response.getErrorMessage());
            } else {
                pushRecordDTO.setReqSuccess(true);
            }
            this.outsidePushRecordRepository.savePushRecord(pushRecordDTO);
            log.info("Forest\u62e6\u622a\u5668\u65b9\u5f0f\u8c03\u7528\u6210\u529f\uff0c\u72b6\u6001: {}", (Object)response.getStatus());
            return response;
        }
        catch (NcApiException e) {
            log.error("NC\u63a5\u53e3\u4e1a\u52a1\u5f02\u5e38: {}", (Object)e.getMessage(), (Object)e);
            pushRecordDTO.setErrorMsg(e.getMessage());
            pushRecordDTO.setReqSuccess(false);
            this.outsidePushRecordRepository.savePushRecord(pushRecordDTO);
            throw e;
        }
        catch (Exception e) {
            log.error("Forest\u62e6\u622a\u5668\u65b9\u5f0f\u8c03\u7528NC\u63a5\u53e3\u5f02\u5e38", (Throwable)e);
            pushRecordDTO.setErrorMsg(e.getMessage());
            pushRecordDTO.setReqSuccess(false);
            this.outsidePushRecordRepository.savePushRecord(pushRecordDTO);
            throw new BusinessException("Forest\u8c03\u7528NC\u63a5\u53e3\u5931\u8d25: " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public String getToken(String secret, String userCode, String timestamp) {
        Assert.hasText((String)secret, (String)"secrect can not be null");
        Assert.hasText((String)userCode, (String)"userCode can not be null");
        Assert.hasText((String)timestamp, (String)"timestamp can not be null");
        String[] sign = new String[]{secret, userCode, timestamp};
        try {
            return NcServiceImpl.signature(sign);
        }
        catch (Exception e) {
            log.error("nc token error", (Throwable)e);
            return "";
        }
    }

    public static String signature(String[] arr) throws Exception {
        StringBuilder content = new StringBuilder();
        for (int i = 0; i < arr.length; ++i) {
            content.append(arr[i]);
        }
        return NcServiceImpl.signature(content.toString(), "SHA-1");
    }

    public static String signature(String content, String algorithm) throws Exception {
        if (algorithm == null || !algorithm.equalsIgnoreCase("MD5") && !algorithm.equalsIgnoreCase("SHA-1")) {
            throw new Exception("\u4e0d\u652f\u6301\u52a0\u5bc6\u7b97\u6cd5\uff1a" + algorithm);
        }
        MessageDigest md = null;
        String tmpStr = null;
        md = MessageDigest.getInstance(algorithm);
        byte[] diagest = md.digest(content.getBytes());
        tmpStr = NcServiceImpl.byteToStr(diagest);
        return tmpStr;
    }

    private static String byteToStr(byte[] byteArray) {
        Object strDigest = "";
        for (int i = 0; i < byteArray.length; ++i) {
            strDigest = (String)strDigest + NcServiceImpl.byteToHexStr(byteArray[i]);
        }
        return strDigest;
    }

    private static String byteToHexStr(byte mByte) {
        char[] Digit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        char[] tempArr = new char[]{Digit[mByte >>> 4 & 0xF], Digit[mByte & 0xF]};
        String s = new String(tempArr);
        return s;
    }

    public NcServiceImpl(NcProperties ncProperties, NcForestClient ncForestClient, OutsidePushRecordRepository outsidePushRecordRepository) {
        this.ncProperties = ncProperties;
        this.ncForestClient = ncForestClient;
        this.outsidePushRecordRepository = outsidePushRecordRepository;
    }
}

