package com.elitesland.zhiyuan.openapi.outer.jackyun.data.core;

/**
 * API 接口枚举
 luoxin
 */
public enum ApiEnum {

    OMSTRADEFULLINFOGET("销售单查询","oms.trade.fullinfoget"),
    OMSCDSCUSTOMSGOODSLIST("进口货品信息查询","oms-cds.customsgoodslist"),
    WMSODSORDERBASECREATE("创建发货单","wms-ods.order.basecreate"),
    WMSORDERQUERYINFOPAGE("查询发货单（分页）","wms.order.query-info.page"),
    WMSORDERQUERYINFOPAGEV2("查询未完成发货单（分页）","wms.order.query-info.page.v2"),
    WMSORDERQUERYPAGE("查询发货单（分页带货位）","wms.order.query.page"),
    ERPCOMPANYCREATE("创建公司","erp.company.create"),
    ERPCOMPANYQUERY("查询公司","erp.company.query"),
    ERPGOODSSKUIMPORTBATCH("批量创建货品","erp.goods.skuimportbatch"),
    ERPGOODSCATEGET("货品分类查询","erp.goodscate.get"),
    ERPSALESGET("销售渠道查询","erp.sales.get"),
    ERPWAREHOUSEGET("开放平台仓库查询","erp.warehouse.get"),
    ERPSALECHANNELCREATEV2("新增渠道","erp.salechannel.create.v2"),
    ERPPURCHGET("采购单查询","erp.purch.get"),
    ERPBASEINFOFLAGGETFLAGID("开放平台根据标记名称获取标记id","erp-baseinfo.flag.getflagid"),
    ERPGOODSONLINEITEMBATCHIMPORTIMAGE("开放平台批量添加资质图","erp-goods-online.item.batchimportimage"),
    ERPGPPDSGPPDSBATCHUPDATEFLAG("开放平台批量修改货品标记","erp-goods.goods.batchupdateflag"),
    ERPGOODSGOODSBATCHUPDATEFLAG("开放平台批量修改货品标记","erp-goods.goods.batchupdateflag"),
    ERPGOODSGOODSBATCHUPDATEFLAGBYSKUBARCODE("开放平台根据条码批量修改货品标记","erp-goods.goods.batchupdateflagbyskubarcode"),
    ERPGOODSGOODSGETFORQIMEN("查询吉客云货品档案信息（仿奇门返回）","erp-goods.goods.getforqimen"),
    ERPGOODSGOODSLISTGOODSPACKAGE("根据组合装货品名称，编号，规格名称，编码，查询组合装","erp-goods.goods.listgoodspackage"),
    ERPBRANDADD("(开放平台货品品牌新增接口)","erp.brand.add"),
    ERPBRANDDEL("开放平台货品品牌删除接口","erp.brand.del"),
    ERPBRANDGET("开放平台货品品牌列表查询","erp.brand.get"),
    ERPGOODSASSISTBARCODECREATE("添加辅助条码","erp.goods.assistbarcodecreate"),
    ERPGOODSASSISTBARCODEUPDATE("批量更新辅助条码","erp.goods.assistbarcodeupdate"),
    ERPGOODSCUSTOMFIELD("获取货品自定义字段的说明的接口","erp.goods.customfield"),
    ERPGOODSCATEADD("开放平台货品分类新增接口","erp.goodscate.add"),
    ERPPACKAGEGOODSIMPORT("添加组合装商品","erp.packagegoods.import"),
    ERPPRICELISTGET("查询货品价目信息","erp.pricelist.get"),
    ERPSALESGOODSSKUPRICECREATE("创建货品价目（已经存在则修改，根据规格、单位、币种定位）","erp.salesgoodsskuprice.create"),
    ERPSERIALNOADD("开放平台新增唯一码接口","erp.serialno.add"),
    ERPSTORAGEASSISTBARCODE("辅助条码查询","erp.storage.assistbarcode"),
    ERPSTORAGEGOODSLIST("分页查询货品信息","erp.storage.goodslist"),
    ERPUNITCREATE("辅助单位创建","erp.unit.create"),
    ERPUNITGET("辅助单位查询","erp.unit.get"),
    ERPSALECHANNELUPDATE("更新销售渠道","erp.salechannel.update"),
    ERPADDRESSGETLIST("查询地址信息","erp.address.getList"),
    ERPGOODSSOURCECREATE("根据条码和供应商编号创建供应商报价","erp.goodssource.create"),
    ERPGOODSSOURCEGETBYCOL("开放平台供应商货品价目查询按需","erp.goodssource.getbycol"),
    ERPVENDCREATE("供应商创建","erp.vend.create"),
    ERPVENDCREATEV2("供应商更新创建","erp.vend.create.v2"),
    ERPVENDGET("供应商查询","erp.vend.get"),
    ERPVENDUPDATE("供应商更新","erp.vend.update"),
    ERPVENDPRICECREATE("开放平台供应商报价开单对外接口","erp.vendprice.create"),
    ERPCOMPANYCREATEV2("创建或更新公司接口","erp.company.create.v2"),
    ERPDEPARTCREATEV2("创建或者更新部门","erp.depart.create.v2"),
    ERPDEPARTQUERY("查询部门","erp.depart.query"),
    ERPUSERBLOCKUP("用户档案停用接口","erp.user.blockup"),
    ERPUSERCREATEV2("创建或更新员工档案","erp.user.create.v2"),
    ERPUSERSEARCH("用户档案查询接口","erp.user.search"),
    OMSCDSCUSTOMSORDERLIST("报关单信息查询","oms-cds.customsorderlist"),
    OMSCDSCUSTOMSORDERSTATUS("开放接口查询报关单状态信息","oms-cds.customsOrderStatus"),
    OMSCDSINVENTORYINFOLIST("开放接口查询清单信息","oms-cds.inventoryInfolist"),
    OMSOPENTRADEAUDITREJECT("销售单驳回审核","oms.open.trade.audit.reject"),
    OMSOPENTRADESETTLEALLINFO("结算单查询","oms.open.trade.settle.allinfo"),
    OMSORDERBATCHSENDSMS("销售单批量发送短信","oms.order.batchsendsms"),
    OMSORDERCOLUMNEXTEDIT("开放平台更新销售单自定义字段对外接口","oms.order.columnext.edit"),
    OMSORDERCONFIRMDELIVERY("发货确认","oms.order.confirm.delivery"),
    OMSORDERCUSTOMSNOTIFY("报关结果通知","oms.order.customs.notify"),
    OMSORDEREXPENSELIST("销售单费用查询","oms.order.expenselist"),
    OMSORDERFLAGBATCHEDIT("批量修改订单标记","oms.order.flag.batchedit"),
    OMSORDERGOODSSTATISTIC("统计销售单货品信息","oms.order.goods.statistic"),
    OMSORDERUPDATELOCKBILLSTATUS("开放平台更新锁账状态接口","oms.order.updateLockBillStatus"),
    OMSTRADEAUDITPASS("销售单审核","oms.trade.audit.pass"),
    OMSTRADEGOODSGETINFOBYBRAND("根据品牌查询货品销售信息","oms.trade.goods.getinfobybrand"),
    OMSTRADEORDERBATCHUPDATELOGISTICWAREHOUSE("销售单修改仓库或物流信息","oms.trade.order.batchUpdateLogisticWarehouse"),
    OMSTRADEORDERDELETE("根据网店订单号删除已取消销售单","oms.trade.order.delete"),
    OMSTRADEORDERREAUDIT("销售单复核","oms.trade.order.reAudit"),
    OMSTRADEORDERCANCEL("取消订单","oms.trade.ordercancel"),
    OMSTRADEORDERCREATE("销售单创建","oms.trade.ordercreate"),
    OMSTRADEORDERLOGLIST("获取销售单日志列表","oms.trade.orderloglist"),
    OMSTRADEQUOTATIONBATCHUPDATEGOODSMEMO("更新意向单货品备注","oms.trade.quotation.batchUpdateGoodsMemo"),
    OMSTRADEQUOTATIONQUERYLIST("意向单查询（包括货品）","oms.trade.quotation.querylist"),
    OMSTRADEREMARKADD("开放接口订单备注操作","oms.trade.remark.add"),
    OMSTRADESETTLEEDIT("更新销售结算单自定义字段","oms.trade.settle.edit"),
    OMSAPIBUSINESSGETMATCHGOODS("获取已匹配商品信息","omsapi-business.get.match.goods"),
    OMSAPIBUSINESSORDERGET("网店订单列表详情","omsapi-business.order.get"),
    OMSAPIBUSINESSTRADEONLINEORDERDETAIL("网店订单详情","omsapi-business.tradeonline.order.detail"),
    WMSTRANSPORTDELIVERLISTALL("查询配送单","wms-transport.deliver.listall"),
    WMSWISRECEIVEQUERY("获取收货单","wms-wis.receive.query"),
    WMSBATCHCREATEBOX("批量新增箱子","wms.batch.createbox"),
    WMSEXTPICKFLAGAGVORDER("标记发货单","wms.extpick.flagagvorder"),
    WMSLABELQUERYINFOPAGE("查询标签（分页）","wms.label.query-info.page"),
    WMSORDERADDFLAGS("批量添加发货单标记","wms.order.add-flags"),
    WMSORDERBASECANCEL("取消发货单","wms.order.basecancel"),
    WMSORDERBASICBATCHCONFIRMSYNC("批量发货确认(逆向)-同步","wms.order.basicbatchconfirmsync"),
    WMSORDERPACK("打包登记","wms.order.pack"),
    WMSORDERPENDING("发货单挂起或恢复","wms.order.pending"),
    WMSORDERPROCESS("发货单流水通知","wms.order.process"),
    WMSORDERQUERYINFO("查询发货单","wms.order.query-info"),
    WMSORDERUPLOADSTOCKOUTPICTURE("上传称重图片","wms.order.upload-stockout-picture"),
    ERPWAREHOUSECREATE("仓库创建","erp.warehouse.create"),
    ERPWAREHOUSECREATEV2("创建或更新存放仓库","erp.warehouse.create.v2"),
    WMSBATCHCREATEBOXBATCH("批量新增箱子","wms.batch.createboxbatch"),
    ERPBMQMQINOUTCALLBACK("出入库回传重试","erp-bmq.mq.inoutcallback"),
    ERPBMQRESERVECREATE("创建预留单","erp-bmq.reserve.create"),
    ERPSTOCKASSEMBLEGETASSEMBLEINCOUNT("查询组装拆卸在途数量","erp-stock.assemble.getAssembleInCount"),
    ERPSTOCKSKUSTOCKSEARCH("委外仓批次库存查询","erp-stock.sku.stock.search"),
    ERPSTOCKUPDATESTOCKCUSTOMFIELDS("批量更新出入库单自定义字段","erp-stock.update.stockCustomFields"),
    ERPBATCHSTOCKQUANTITYGET("批次库存查询","erp.batchstockquantity.get"),
    ERPCORRECTRECORD("批次纠错列表查询","erp.correct.record"),
    ERPPERIODGETLIST("查询当前期间成本","erp.period.getList"),
    ERPSTOCKQUANTITYADJUST("三方仓库存校准","erp.stock.quantityadjust"),
    ERPSTOCKQUANTITYADJUSTBYUNITNAME("三方仓库存校准(带单位)","erp.stock.quantityadjustbyunitname"),
    ERPSTOCKQUANTITYGET("库存分页查询","erp.stockquantity.get"),
    WMSWISFINISHAGVSTOCKMOVE("库存移动","wms-wis.finish.agvstockmove"),
    WMSPOSITIONGOODSSTOCKBATCH("查询货位库存","wms.position.goods-stock-batch"),
    ERPBUSIORDERGOODSDOCINSEARCH("入库查询（规格模式）","erp-busiorder.goodsdocin.search"),
    ERPREVOKESTOCKIN("入库通知取消","erp.revoke.stockin"),
    ERPSTOCKCLOSESTOCKIN("根据申请单号关闭入库申请单","erp.stock.closestockin"),
    ERPSTOCKCREATEANDSTOCKIN("创建入库申请单并入库","erp.stock.createandstockin"),
    ERPSTOCKFINISHSTOCKIN("完成入库申请单","erp.stock.finishstockin"),
    ERPSTOCKINCLOSE("根据关联单号关闭入库申请单","erp.stockin.close"),
    ERPSTOCKINFORCECLOSE("强制关闭入库申请单","erp.stockin.force.close"),
    ERPSTOCKINGET("分页查询入库申请单","erp.stockin.get"),
    ERPSTOCKINGETV2("按需查询入库申请单货品模式","erp.stockin.get.v2"),
    ERPSTORAGEGOODSDOCINCOUNTS("入库单查询单据数量","erp.storage.goodsdocin.counts"),
    ERPSTORAGEGOODSDOCINV2("入库单查询","erp.storage.goodsdocin.v2"),
    ERPSTORAGESTOCKINCREATE("入库申请单创建","erp.storage.stockincreate"),
    WMSWISRECEIVEREGISTER("创建收货登记","wms-wis.receive.register"),
    WMSEXTPICKQUERYENTRYORDER("查询入库单","wms.extpick.queryentryorder"),
    ERPBUSIORDERGOODSDOCOUTSEARCH("出库查询（规格模式）","erp-busiorder.goodsdocout.search"),
    ERPREVOKESTOCKOUT("出库通知取消","erp.revoke.stockout"),
    ERPSTOCKCLOSESTOCKOUT("根据申请单号关闭出库申请单","erp.stock.closestockout"),
    ERPSTOCKCREATEANDSTOCKOUT("创建出库申请单并出库","erp.stock.createandstockout"),
    ERPSTOCKFINISHSTOCKOUT("完成出库申请单","erp.stock.finishstockout"),
    ERPSTOCKOUTCLOSE("根据关联单号关闭出库申请单","erp.stockout.close"),
    ERPSTOCKOUTFORCECLOSE("强制关闭出库申请单","erp.stockout.force.close"),
    ERPSTOCKOUTGET("分页查询出库申请单","erp.stockout.get"),
    ERPSTOCKOUTGETV2("按需查询出库申请单货品模式","erp.stockout.get.v2"),
    ERPSTORAGEGOODSDOCOUTCOUNTS("出库单查询单据数量","erp.storage.goodsdocout.counts"),
    ERPSTORAGEGOODSDOCOUTV2("分页查询出库单","erp.storage.goodsdocout.v2"),
    ERPSTORAGESTOCKOUTCREATE("出库申请单创建","erp.storage.stockoutcreate"),
    WMSWPSEXTPICKCONFIRMBATCH("发货确认","wms-wps.extpick.confirmBatch"),
    WMSWPSEXTPICKTASKCREATE("AGV生成拣货任务","wms-wps.extpick.task.create"),
    WMSEXTPICKGETDELIVERYORDER("获取发货单","wms.extpick.getdeliveryorder"),
    WMSORDERPACKLIST("根据发货单号查询包裹","wms.order.packlist"),
    ERPALLOCATECOMPLETE("调拨完成","erp.allocate.complete"),
    ERPALLOCATECREATE("开放平台调拨单创建对外接口","erp.allocate.create"),
    ERPALLOCATEGET("调拨查询","erp.allocate.get"),
    ERPALLOCATEQUICKCREATE("调拨单一键调拨(非标准一键调拨)","erp.allocate.quick.create"),
    ERPCLLOCATERETURNCREATE("调拨退回","erp.allocateReturn.create"),
    WMSEXTPICKCREATEINVENTORY("生成盘点单","wms.extpick.createinventory"),
    WMSEXTPICKGETSTOCKPD("获取盘点单","wms.extpick.getstockpd"),
    WMSSTOCKTAKEBASECREATE("盘点单创建","wms.stocktake.basecreate"),
    ERPCOMBINDCREATE("开放平台创建组装拆卸的接口","erp.combind.create"),
    ERPCOMBINEDCLOSE("组装拆卸单关闭","erp.combined.close"),
    ERPCOMBINEDGETV2("开放平台查询组装拆卸单","erp.combined.get.v2"),
    ERPCOMBINEDQUICKCOMBINED("开放平台一键组装拆卸","erp.combined.quickcombined"),
    ERPTEMPLATECREATE("开放平台新建组装拆卸模板","erp.template.create"),
    ERPTEMPLATEGET("开放平台查询组装拆卸模板","erp.template.get"),
    ERPTEMPLATEQUERY("条件查询组装拆卸模板明细","erp.template.query"),





    ;

    private ApiEnum(String caption,String value)
    {
        this.caption = caption;
        this.value = value;
    }
    /**
     * 标题
     */

    private String caption;
    /**
     *   API名称
     */
    private  String value;

    /**
     *  获取标题
     * @return  标题
     */
    public String getCaption() {
        return this.caption;
    }
    /**
     * 获取 枚举值
     *
     * @return 枚举值
     */
    public String getValue() {
        return value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    /**
     * 枚举值字符串
     *
     * @return S
     */
    @Override
    public String toString() {
        return this.getValue().toString();
    }

    /**
     * 根据吉克云方法值找到枚举
     *
     * @param value 枚举的吉克云方法值
     * @return 枚举
     */
    public static ApiEnum getEnumByValue(String value) {
        for (ApiEnum apiEnum : ApiEnum.values()) {
            if (apiEnum.getValue().equals(value)) {
                return apiEnum;
            }
        }
        return null;
    }
}
