package com.elitesland.zhiyuan.openapi.outer.jushuitan.service;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.zhiyuan.openapi.Application;
import com.elitesland.zhiyuan.openapi.outer.jushuitan.params.req.NoTaoOrderQueryRequest;
import com.elitesland.zhiyuan.openapi.outer.jushuitan.params.req.QimenOrderQueryRequest;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 聚水潭查询服务.
 * <p>
 * 普通查询，不作日志记录
 *
 * @author Kaiser（wang shao）
 * @date 2025/10/9 周四
 */
@FeignClient(name = Application.NAME, path = JushuitanQueryRpcService.URI)
@Validated
public interface JushuitanQueryRpcService {
    String URI = Application.URI_PREFIX + "/jushuitan/query";

    /**
     * 淘系订单查询
     *
     * @return String
     */
    @PostMapping("/tao/query")
    @ApiOperation("淘系订单查询")
    ApiResult<String> taoOrderQuery(@RequestBody QimenOrderQueryRequest orderQueryRequest);


    /**
     * 非淘系订单查询
     *
     * @return String
     */
    @PostMapping(value = "/notao/query")
    @ApiOperation("非淘系订单查询")
    ApiResult<String> nontaoOrderQuery(@RequestBody NoTaoOrderQueryRequest noTaoOrderQueryRequest);
}
