package com.elitesland.zhiyuan.openapi.outer.jushuitan.params.req;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

/**
 * https://openweb.jushuitan.com/dev-doc?docType=7&docId=270#请求示例
 * ClassName: PurchaseInboundRequest
 * Description: 采购入库单请求参数
 *
 * @author system
 * @date 2024/10/28
 */
@Data
public class PurchaseInboundRequest {

    @ApiModelProperty(value = "是否自动确认单据，默认false", required = true)
    private Boolean is_confirm;

    @ApiModelProperty(value = "外部采购入库单号唯一", required = true)
    private String external_id;

    @ApiModelProperty(value = "供应商内部编号", required = true)
    private Integer supplier_id;

    @ApiModelProperty("采购单号/加工单号")
    private Integer po_id;

    @ApiModelProperty("货主采购单号")
    private Integer outer_po_id;

    @ApiModelProperty("分仓编码")
    private Integer wms_co_id;

    @ApiModelProperty("仓库编码：主仓=1，销退仓=2，进货仓=3，次品仓=4，自定义1仓=6，自定义2仓=7，自定义3仓=8")
    private Integer warehouse;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("税率")
    private BigDecimal tax_rate;

    @ApiModelProperty("货主仓库编号")
    private String co_id;

    @ApiModelProperty("虚拟仓名称")
    private String lock_wh_name;

    @ApiModelProperty("虚拟仓编码（对应lwh_id）")
    private String lock_wh_id;

    @ApiModelProperty("创建人；不填写默认@open")
    private String channel;

    @ApiModelProperty("是否按箱入库")
    private Boolean is_in_by_pack;

    @ApiModelProperty("是否到商品明细上传箱号")
    private Boolean is_create_pack_by_item;

    @ApiModelProperty("已有箱号（is_in_by_pack 为true有效）")
    private String old_pack_id;

    @ApiModelProperty("是否校验混装，传true时混装会报错")
    private Boolean is_check_mix_pack;

    @ApiModelProperty("是否点数批量装箱（is_in_by_pack 为true有效）")
    private Boolean is_bulk_pack;

    @ApiModelProperty("箱数（is_in_by_pack 为true且非is_bulk_pack有效）")
    private Integer pack_qty;

    @ApiModelProperty(value = "商品明细，最大1000条", required = true)
    private List<PurchaseInboundItem> items;

    /**
     * 商品明细内部类
     */
    @Data
    public static class PurchaseInboundItem {

        @ApiModelProperty(value = "数量", required = true)
        private Integer qty;

        @ApiModelProperty("税率")
        private BigDecimal tax_rate;

        @ApiModelProperty(value = "商品编码", required = true)
        private String sku_id;

        @ApiModelProperty("箱号")
        private String pack_id;

        @ApiModelProperty("序列号（非黄金版使用）")
        private List<String> sku_sn;

        @ApiModelProperty("序列号（erp黄金版使用）")
        private List<SkuSnItem> sku_sn_list;

        @ApiModelProperty("单价")
        private String price;

        @ApiModelProperty("批次号，系统中相关业务项需配置")
        private String batch_id;

        @ApiModelProperty("生产日期，系统中相关业务项需配置")
        private String produced_date;

        @ApiModelProperty("有效期至，系统中相关业务项需配置")
        private String expiration_date;

        @ApiModelProperty("备注")
        private String remark;
    }

    /**
     * 序列号明细（黄金版专用）
     */
    @Data
    public static class SkuSnItem {

        @ApiModelProperty(value = "唯一码", required = true)
        private String sku_sn;

        @ApiModelProperty("唯一码成本价")
        private BigDecimal cost_price;

        @ApiModelProperty("备注")
        private String remark;

        @ApiModelProperty("重量")
        private BigDecimal weight;

        @ApiModelProperty("黄金版叫证书编号，非黄金版叫辅助唯一码")
        private String certificate_no;

        @ApiModelProperty("加工费（黄金版专用参数）")
        private BigDecimal processing_charges;

        @ApiModelProperty("加工费单价（黄金版专用参数）")
        private BigDecimal processing_price;

        @ApiModelProperty("原材料单价（黄金版专用参数）")
        private BigDecimal raw_material_price;

        @ApiModelProperty("原材料成本（黄金版专用参数）")
        private BigDecimal raw_material_amount;

        @ApiModelProperty("附加费（黄金版专用参数）")
        private BigDecimal surcharge;

        @ApiModelProperty("计价方式，0=固定价格，1=结料结工费，2=结价结工费（黄金版专用参数）")
        private Integer pricing_method;

        @ApiModelProperty("唯一码入库扩展信息（黄金版专用参数）")
        private InExtModel in_ext_model;

        @ApiModelProperty("其它属性1")
        private String other1;

        @ApiModelProperty("其它属性2")
        private String other2;

        @ApiModelProperty("其它属性3")
        private String other3;

        @ApiModelProperty("其它重量1")
        private BigDecimal other_weight1;

        @ApiModelProperty("其它重量2")
        private BigDecimal other_weight2;

        @ApiModelProperty("其它重量3")
        private BigDecimal other_weight3;

        @ApiModelProperty("其它成本1")
        private BigDecimal other_costPrice1;

        @ApiModelProperty("其它成本2")
        private BigDecimal other_costPrice2;

        @ApiModelProperty("其它成本3")
        private BigDecimal other_costPrice3;

        @ApiModelProperty("其它加工费1")
        private BigDecimal other_processing_charges1;

        @ApiModelProperty("其它加工费2")
        private BigDecimal other_processing_charges2;

        @ApiModelProperty("其它加工费3")
        private BigDecimal other_processing_charges3;
    }

    /**
     * 唯一码入库扩展信息（黄金版专用）
     */
    @Data
    public static class InExtModel {
        // 根据实际业务需求添加字段
    }
}