/*
 * Copyright(C) 2017 Hangzhou Differsoft Co., Ltd. All rights reserved.
 */

package com.elitesland.zhiyuan.openapi.outer.jackyun.util;

import java.time.*;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.concurrent.TimeUnit;

/**
 * 时间转换工具类
 *
 * @author hup
 * @since 2020-02-21 9:43:28
 */
public class DateTimeUtils {
    /**
     * 默认时间格式: yyyy-MM-dd HH:mm:ss
     */

    private static final DateTimeFormatter DEFAULT_DATETIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");

    /**
     * String 转时间(localDateTime)
     *
     * @param timeStr 时间字符串
     * @return 转时间
     */
    public static LocalDateTime stringToTime(String timeStr) {
        return LocalDateTime.parse(timeStr, DEFAULT_DATETIME_FORMATTER);
    }


    /**
     * 根据指定时间，单位，偏移量获取偏移后的时间对象;偏移后的时间对象序列化格式为:yyyy-MM-dd HH:mm:ss
     *
     * @param time   localDateTime时间对象
     * @param offset 偏移量:正数,往后偏移;负数:往前偏移
     * @param unit   偏移的时间单位
     * @return
     */
    public static LocalDateTime timeOffset(LocalDateTime time, long offset, TimeUnit unit) {
        switch (unit) {
            case MILLISECONDS:
                time = time.plusSeconds(offset / 1000);
                break;
            case SECONDS:
                time = time.plusSeconds(offset);
                break;
            case MINUTES:
                time = time.plusMinutes(offset);
                break;
            case HOURS:
                time = time.plusHours(offset);
                break;
            case DAYS:
                time = time.plusDays(offset);
                break;
        }
        String newDate = time.format(DEFAULT_DATETIME_FORMATTER);
        return DateTimeUtils.stringToTime(newDate);
    }

    /**
     * 获取当前时间戳（13位）
     *
     * @return 时间戳
     */
    public static long getTimestamp() {
        return LocalDateTime.now().toInstant(ZoneOffset.of("+8")).toEpochMilli();
    }

}
