/*
 * Copyright(C) 2017 Hangzhou Differsoft Co., Ltd. All rights reserved.
 */

package com.elitesland.zhiyuan.openapi.outer.jackyun.service;



import com.elitesland.zhiyuan.openapi.outer.jackyun.data.JackyunResponse;
import com.elitesland.zhiyuan.openapi.outer.jackyun.data.bizdata.core.BaseRequestBizData;
import com.elitesland.zhiyuan.openapi.outer.jackyun.service.core.JackyunMemberInfo;
import com.elitesland.zhiyuan.openapi.outer.jackyun.service.core.JackyunOpenHttpUtils;
import com.elitesland.zhiyuan.openapi.outer.jackyun.util.JsonUtils;

import java.util.List;

/**
 * 请求吉客云开放平台服务。
 *
 * @author luoxin
 */
public class JackyunOpenClientService {
    /**
     * 请求开放平台服务。
     * @param method 开放接口方法名
     * @param bizData 请求业务数据
     * @return OpenResponse返回对象
     */
    public JackyunResponse call(String method, BaseRequestBizData bizData) {
        //接口返回值
        JackyunResponse response = null;
        //返回值字符串
        String strResponse = null;
        JackyunMemberInfo memberInfo = new JackyunMemberInfo();
        try {
            //请求吉客云开放接口。
            strResponse = JackyunOpenHttpUtils.post(method, "v1.0", JsonUtils.toJson(bizData),memberInfo);
        } catch (Exception ex) {
            response = new com.elitesland.zhiyuan.openapi.outer.jackyun.data.JackyunResponse();
            response.onFail(ex.getMessage(), "CLIENT_EXCEPTION");
            return response;
        }
        return JsonUtils.deJson(strResponse, com.elitesland.zhiyuan.openapi.outer.jackyun.data.JackyunResponse.class);
    }
    /**
     * 请求开放平台服务。
     * @param method 开放接口方法名
     * @param bizDataList 请求业务数据 数组
     * @return OpenResponse返回对象
     */
    public JackyunResponse callBatch(String method, List<BaseRequestBizData> bizDataList) {
        //接口返回值
        JackyunResponse response = null;
        //返回值字符串
        String strResponse = null;
        JackyunMemberInfo memberInfo = new JackyunMemberInfo();

        try {
            //请求吉客云开放接口。
            strResponse = JackyunOpenHttpUtils.post(method, "v1.0", JsonUtils.toJson(bizDataList),memberInfo);
        } catch (Exception ex) {
            response = new JackyunResponse();
            response.onFail(ex.getMessage(), "CLIENT_EXCEPTION");
            return response;
        }
        return JsonUtils.deJson(strResponse, JackyunResponse.class);
    }
}
