/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.zhiyuan.openapi.outer.jushuitan.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.zhiyuan.openapi.outer.jushuitan.common.service.JstService;
import com.elitesland.zhiyuan.openapi.outer.jushuitan.config.JstProperties;
import com.elitesland.zhiyuan.openapi.outer.jushuitan.params.req.JstTryFunDTO;
import com.elitesland.zhiyuan.openapi.outer.jushuitan.params.req.PurchaseInboundListRequest;
import com.elitesland.zhiyuan.openapi.outer.jushuitan.params.resp.JushuitanBaseResponse;
import com.elitesland.zhiyuan.openapi.outer.jushuitan.params.resp.PurchaseInboundResponse;
import com.elitesland.zhiyuan.openapi.outer.jushuitan.service.JushuitaService;
import com.elitesland.zhiyuan.openapi.outer.nc.exception.NcApiException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/jst/retry"})
@Api(value="JST\u91cd\u8bd5\u63a5\u53e3", tags={"JST\u91cd\u8bd5\u63a5\u53e3"})
public class JstRetryController {
    private static final Logger log = LoggerFactory.getLogger(JstRetryController.class);
    private final JstService jstService;
    private final JushuitaService jushuitaService;
    private final JstProperties jstProperties;

    @PostMapping(value={"/tryFun"})
    @ApiOperation(value="JST\u91cd\u8bd5\u63a5\u53e3")
    public ApiResult<JushuitanBaseResponse> tryFun(@RequestBody JstTryFunDTO jstTryFunDTO, String url) throws IOException {
        URL uri = new URL(this.jstProperties.getServerUrl() + url);
        String rspStr = this.jstService.callApi(uri, jstTryFunDTO.getParams());
        if (!StringUtils.hasText((String)rspStr)) {
            throw new NcApiException("YST\u63a5\u53e3\u8fd4\u56de\u7a7a\u54cd\u5e94");
        }
        try {
            JushuitanBaseResponse response = (JushuitanBaseResponse)JSON.parseObject((String)rspStr, JushuitanBaseResponse.class);
            if (response == null) {
                log.error("JST\u63a5\u53e3\u54cd\u5e94\u89e3\u6790\u5931\u8d25: {}", (Object)rspStr);
                return ApiResult.fail((String)"JST\u63a5\u53e3\u54cd\u5e94\u89e3\u6790\u5931\u8d25");
            }
            if (!response.isSuccess()) {
                String errorMessage = response.getMsg();
                log.error("JST\u63a5\u53e3\u8c03\u7528\u5931\u8d25: {}", (Object)errorMessage);
                return ApiResult.fail((String)errorMessage);
            }
            log.info("JST\u63a5\u53e3\u8c03\u7528\u6210\u529f");
            return ApiResult.ok((Object)response);
        }
        catch (JSONException e) {
            log.error("JST\u63a5\u53e3\u54cd\u5e94JSON\u89e3\u6790\u5931\u8d25: {}", (Object)rspStr, (Object)e);
            return ApiResult.fail((String)"JST\u63a5\u53e3\u54cd\u5e94\u683c\u5f0f\u9519\u8bef");
        }
    }

    @PostMapping(value={"/testPurchaseinCreatebatch"})
    @ApiOperation(value="JST \u91c7\u8d2d\u5165\u5e93 Test\u63a5\u53e3")
    public ApiResult<PurchaseInboundResponse> testPurchaseinCreatebatch(@RequestBody PurchaseInboundListRequest purchaseInboundListRequest, Long docId, String docNo) throws Exception {
        PurchaseInboundResponse rspStr = this.jushuitaService.purchaseinCreatebatch(purchaseInboundListRequest, docId, docNo);
        return ApiResult.ok((Object)rspStr);
    }

    public JstRetryController(JstService jstService, JushuitaService jushuitaService, JstProperties jstProperties) {
        this.jstService = jstService;
        this.jushuitaService = jushuitaService;
        this.jstProperties = jstProperties;
    }
}

