package com.elitesland.zhiyuan.openapi.outer.jushuitan.params.resp;

/**
 * ClassName: JushuitanErrorCode
 * Description: 聚水潭API错误码枚举
 *
 * @author system
 * @date 2024/10/28
 */
public enum JushuitanErrorCode {

    /**
     * 成功
     */
    SUCCESS(0, "成功"),

    /**
     * 调用频繁
     */
    TOO_FREQUENT(199, "调用太频繁，请稍后再试!");

    private final Integer code;
    private final String message;

    JushuitanErrorCode(Integer code, String message) {
        this.code = code;
        this.message = message;
    }

    public Integer getCode() {
        return code;
    }

    public String getMessage() {
        return message;
    }

    /**
     * 根据错误码获取枚举
     * @param code 错误码
     * @return 对应的枚举，如果没找到返回null
     */
    public static JushuitanErrorCode getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        for (JushuitanErrorCode errorCode : values()) {
            if (errorCode.getCode().equals(code)) {
                return errorCode;
            }
        }
        return null;
    }

    /**
     * 判断是否为成功状态
     * @param code 错误码
     * @return true表示成功，false表示失败
     */
    public static boolean isSuccess(Integer code) {
        return SUCCESS.getCode().equals(code);
    }

    /**
     * 判断是否为调用频繁
     * @param code 错误码
     * @return true表示调用频繁，false表示正常
     */
    public static boolean isTooFrequent(Integer code) {
        return TOO_FREQUENT.getCode().equals(code);
    }
}