/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.zhiyuan.openapi.outer.jushuitan.service.impl;

import com.alibaba.fastjson.JSON;
import com.elitescloud.cloudt.sys.outlog.OutsidePushInter;
import com.elitescloud.cloudt.sys.outlog.param.PushRecordDTO;
import com.elitescloud.cloudt.sys.outlog.rpc.OutsidePushRecordRepository;
import com.elitesland.zhiyuan.openapi.outer.jggyun.params.SupplierRequest;
import com.elitesland.zhiyuan.openapi.outer.jggyun.params.UpdateGoodsRequest;
import com.elitesland.zhiyuan.openapi.outer.jushuitan.common.service.JstService;
import com.elitesland.zhiyuan.openapi.outer.jushuitan.params.req.PurchaseInboundListRequest;
import com.elitesland.zhiyuan.openapi.outer.jushuitan.params.req.WarehouseQueryRequest;
import com.elitesland.zhiyuan.openapi.outer.jushuitan.params.resp.JushuitanBaseResponse;
import com.elitesland.zhiyuan.openapi.outer.jushuitan.params.resp.PurchaseInboundResponse;
import com.elitesland.zhiyuan.openapi.outer.jushuitan.params.resp.SupplierSyncResponse;
import com.elitesland.zhiyuan.openapi.outer.jushuitan.params.resp.WarehouseQueryResponse;
import com.elitesland.zhiyuan.openapi.outer.jushuitan.service.JushuitaService;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
@RefreshScope
public class JushuitaServiceImpl
implements JushuitaService {
    private static final Logger log = LoggerFactory.getLogger(JushuitaServiceImpl.class);
    private final OutsidePushRecordRepository outsidePushRecordRepository;
    private final JstService jstService;

    @Override
    @Transactional
    public JushuitanBaseResponse createMaterial(UpdateGoodsRequest request, String pushRecordInterType, Long docId, String docNo) throws Exception {
        if (request == null || CollectionUtils.isEmpty(request.getItems())) {
            String errorMsg = "createMaterial\u8bf7\u6c42\u53c2\u6570\u4e3a\u7a7a\u6216items\u5217\u8868\u4e3a\u7a7a";
            log.error("\u53c2\u6570\u6821\u9a8c\u5931\u8d25: {}", (Object)errorMsg);
            throw new IllegalArgumentException(errorMsg);
        }
        if (request.getItems().size() > 1) {
            log.warn("createMaterial\u8bf7\u6c42\u5305\u542b{}\u4e2a\u5546\u54c1\uff0c\u4ec5\u5904\u7406\u7b2c\u4e00\u4e2a\u5546\u54c1\u3002\u5efa\u8bae\u6bcf\u6b21\u8bf7\u6c42\u4ec5\u5305\u542b\u4e00\u4e2a\u5546\u54c1", (Object)request.getItems().size());
        }
        log.info("\u805a\u6c34\u6f6d\u7269\u6599\u63a5\u53e3 - \u8bf7\u6c42\u5f00\u59cb | \u5546\u54c1ID: {}, \u8bf7\u6c42\u53c2\u6570: {}", (Object)request.getItems().get(0).getSkuId(), (Object)JSON.toJSONString((Object)request, (boolean)true));
        try {
            Map<String, Object> itemMap = this.buildItemMap(request);
            Map<String, List<Map<String, Object>>> requestMap = Collections.singletonMap("items", Collections.singletonList(itemMap));
            String jsonRequest = JSON.toJSONString(requestMap);
            log.debug("\u805a\u6c34\u6f6d\u7269\u6599\u63a5\u53e3 - \u8bf7\u6c42\u6570\u636e: {}", (Object)jsonRequest);
            JushuitanBaseResponse response = this.jstService.getSellerItem(jsonRequest, "/open/jushuitan/itemsku/upload", OutsidePushInter.ITEM_SYNC_TO_JST.name(), docId, docNo);
            log.debug("\u805a\u6c34\u6f6d\u7269\u6599\u63a5\u53e3 - \u54cd\u5e94: {}", (Object)response);
            if (response == null) {
                log.error("\u805a\u6c34\u6f6d\u7269\u6599\u63a5\u53e3 - \u54cd\u5e94\u4e3a\u7a7a");
                throw new RuntimeException("\u805a\u6c34\u6f6d\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a");
            }
            log.info("\u805a\u6c34\u6f6d\u7269\u6599\u63a5\u53e3 - \u5904\u7406\u5b8c\u6210 | \u5546\u54c1ID: {}, \u54cd\u5e94\u72b6\u6001: {}", (Object)request.getItems().get(0).getSkuId(), (Object)"\u6210\u529f");
            return response;
        }
        catch (Exception e) {
            log.error("\u805a\u6c34\u6f6d\u7269\u6599\u63a5\u53e3\u8c03\u7528\u5f02\u5e38 | \u5546\u54c1ID: {}", (Object)request.getItems().get(0).getSkuId(), (Object)e);
            throw new Exception("\u805a\u6c34\u6f6d\u7269\u6599\u63a5\u53e3\u8c03\u7528\u5931\u8d25: " + e.getMessage(), e);
        }
    }

    private Map<String, Object> buildItemMap(UpdateGoodsRequest request) {
        UpdateGoodsRequest.Item item = request.getItems().get(0);
        HashMap<String, Object> itemMap = new HashMap<String, Object>();
        if (StringUtils.isEmpty((CharSequence)item.getSkuId()) || StringUtils.isEmpty((CharSequence)item.getIId()) || StringUtils.isEmpty((CharSequence)item.getName())) {
            throw new IllegalArgumentException(String.format("\u7269\u6599\u5fc5\u586b\u5b57\u6bb5\u7f3a\u5931 | skuId: %s, iId: %s, name: %s", item.getSkuId(), item.getIId(), item.getName()));
        }
        itemMap.put("sku_id", item.getSkuId());
        itemMap.put("i_id", item.getIId());
        itemMap.put("name", item.getName());
        return itemMap;
    }

    @Override
    @Transactional
    public SupplierSyncResponse syncSupp(SupplierRequest request, String pushRecordInterType, Long docId, String docNo) throws Exception {
        if (request == null || CollectionUtils.isEmpty(request.getSuppliers())) {
            String errorMsg = "syncSupp\u8bf7\u6c42\u53c2\u6570\u4e3a\u7a7a\u6216suppliers\u5217\u8868\u4e3a\u7a7a";
            log.error("\u53c2\u6570\u6821\u9a8c\u5931\u8d25: {}", (Object)errorMsg);
            throw new IllegalArgumentException(errorMsg);
        }
        log.info("\u805a\u6c34\u6f6d\u4f9b\u5e94\u5546\u540c\u6b65\u63a5\u53e3 - \u8bf7\u6c42\u5f00\u59cb | \u4f9b\u5e94\u5546\u6570\u91cf: {}", (Object)request.getSuppliers().size());
        try {
            List failedSuppliers;
            List suppliers = request.getSuppliers().stream().map(this::buildSupplierItemMap).collect(Collectors.toList());
            String jsonRequest = JSON.toJSONString(suppliers);
            log.debug("\u805a\u6c34\u6f6d\u4f9b\u5e94\u5546\u540c\u6b65\u63a5\u53e3 - \u8bf7\u6c42\u6570\u636e: {}", (Object)jsonRequest);
            JushuitanBaseResponse baseResponse = this.jstService.getSellerItem(jsonRequest, "/open/supplier/upload", OutsidePushInter.SUPPORT_SYNC_TO_JST.name(), docId, docNo);
            log.debug("\u805a\u6c34\u6f6d\u4f9b\u5e94\u5546\u540c\u6b65\u63a5\u53e3 - \u54cd\u5e94: {}", (Object)baseResponse);
            SupplierSyncResponse response = this.convertToSupplierSyncResponse(baseResponse);
            if (response.isSuccess() && response.getData() != null && !CollectionUtils.isEmpty(((SupplierSyncResponse.SupplierSyncData)response.getData()).getDatas()) && !(failedSuppliers = ((SupplierSyncResponse.SupplierSyncData)response.getData()).getDatas().stream().filter(data -> !Boolean.TRUE.equals(data.getIssuccess())).map(SupplierSyncResponse.SupplierData::getSupplier_code).collect(Collectors.toList())).isEmpty()) {
                log.warn("\u805a\u6c34\u6f6d\u4f9b\u5e94\u5546\u540c\u6b65\u63a5\u53e3 - \u90e8\u5206\u4f9b\u5e94\u5546\u540c\u6b65\u5931\u8d25 | \u5931\u8d25\u7684\u4f9b\u5e94\u5546\u7f16\u7801: {}", (Object)String.join((CharSequence)",", failedSuppliers));
            }
            log.info("\u805a\u6c34\u6f6d\u4f9b\u5e94\u5546\u540c\u6b65\u63a5\u53e3 - \u5904\u7406\u5b8c\u6210 | \u4f9b\u5e94\u5546\u6570\u91cf: {}, \u72b6\u6001: {}, \u54cd\u5e94\u7801: {}", new Object[]{request.getSuppliers().size(), response.isSuccess() ? "\u6210\u529f" : "\u5931\u8d25", response.getCode()});
            return response;
        }
        catch (Exception e) {
            log.error("\u805a\u6c34\u6f6d\u4f9b\u5e94\u5546\u540c\u6b65\u63a5\u53e3\u5f02\u5e38 | \u4f9b\u5e94\u5546\u6570\u91cf: {}", (Object)request.getSuppliers().size(), (Object)e);
            throw new Exception("\u805a\u6c34\u6f6d\u4f9b\u5e94\u5546\u540c\u6b65\u63a5\u53e3\u5931\u8d25: " + e.getMessage(), e);
        }
    }

    private SupplierSyncResponse convertToSupplierSyncResponse(JushuitanBaseResponse baseResponse) {
        if (baseResponse == null) {
            return null;
        }
        SupplierSyncResponse response = new SupplierSyncResponse();
        response.setCode(baseResponse.getCode());
        response.setMsg(baseResponse.getMsg());
        response.setRequest_id(baseResponse.getRequest_id());
        response.setMsg_type(baseResponse.getMsg_type());
        response.setAct(baseResponse.getAct());
        if (baseResponse.getData() != null) {
            try {
                String dataJson = JSON.toJSONString(baseResponse.getData());
                SupplierSyncResponse.SupplierSyncData supplierData = (SupplierSyncResponse.SupplierSyncData)JSON.parseObject((String)dataJson, SupplierSyncResponse.SupplierSyncData.class);
                response.setData(supplierData);
            }
            catch (Exception e) {
                log.warn("\u8f6c\u6362\u4f9b\u5e94\u5546\u540c\u6b65\u54cd\u5e94\u6570\u636e\u5931\u8d25", (Throwable)e);
            }
        }
        return response;
    }

    @Override
    @Transactional
    public PurchaseInboundResponse purchaseinCreatebatch(PurchaseInboundListRequest request, Long docId, String docNo) throws Exception {
        if (request == null || CollectionUtils.isEmpty(request.getList())) {
            String errorMsg = "purchaseinCreatebatch\u8bf7\u6c42\u53c2\u6570\u4e3a\u7a7a\u6216list\u5217\u8868\u4e3a\u7a7a";
            log.error("\u53c2\u6570\u6821\u9a8c\u5931\u8d25: {}", (Object)errorMsg);
            throw new IllegalArgumentException(errorMsg);
        }
        log.info("\u805a\u6c34\u6f6d\u91c7\u8d2d\u5165\u5e93\u6279\u91cf\u521b\u5efa\u63a5\u53e3 - \u8bf7\u6c42\u5f00\u59cb | \u5165\u5e93\u5355\u6570\u91cf: {}", (Object)request.getList().size());
        try {
            String jsonRequest = JSON.toJSONString(request.getList());
            log.debug("\u805a\u6c34\u6f6d\u91c7\u8d2d\u5165\u5e93\u6279\u91cf\u521b\u5efa\u63a5\u53e3 - \u8bf7\u6c42\u6570\u636e: {}", (Object)jsonRequest);
            JushuitanBaseResponse response = this.jstService.getSellerItem(jsonRequest, "/open/webapi/wmsapi/purchasein/createbatch", OutsidePushInter.INV_IDO_SYNC_TO_JST.name(), docId, docNo);
            log.debug("\u805a\u6c34\u6f6d\u91c7\u8d2d\u5165\u5e93\u6279\u91cf\u521b\u5efa\u63a5\u53e3 - \u54cd\u5e94: {}", (Object)response);
            PurchaseInboundResponse responseObj = (PurchaseInboundResponse)response;
            return responseObj;
        }
        catch (Exception e) {
            log.error("\u805a\u6c34\u6f6d\u91c7\u8d2d\u5165\u5e93\u6279\u91cf\u521b\u5efa\u63a5\u53e3\u5f02\u5e38 | \u5165\u5e93\u5355\u6570\u91cf: {}", (Object)request.getList().size(), (Object)e);
            throw new Exception("\u805a\u6c34\u6f6d\u91c7\u8d2d\u5165\u5e93\u6279\u91cf\u521b\u5efa\u63a5\u53e3\u5931\u8d25: " + e.getMessage(), e);
        }
    }

    private PushRecordDTO buildPushRecordDTO(String interType, String docNo, Long docId) {
        PushRecordDTO dto = new PushRecordDTO();
        dto.setInterType(interType);
        dto.setDocNo("");
        dto.setDocId(Long.valueOf(0L));
        dto.setReqSuccess(false);
        return dto;
    }

    @Override
    @Transactional
    public WarehouseQueryResponse queryWarehouse(WarehouseQueryRequest request, String pushRecordInterType, Long docId, String docNo) throws Exception {
        if (request == null) {
            request = new WarehouseQueryRequest();
        }
        log.info("\u805a\u6c34\u6f6d\u4ed3\u5e93\u67e5\u8be2\u63a5\u53e3 - \u8bf7\u6c42\u5f00\u59cb | \u9875\u7801: {}, \u9875\u5927\u5c0f: {}", (Object)request.getPage_index(), (Object)request.getPage_size());
        try {
            HashMap<String, Integer> requestMap = new HashMap<String, Integer>();
            if (request.getPage_index() != null) {
                requestMap.put("page_index", request.getPage_index());
            }
            if (request.getPage_size() != null) {
                requestMap.put("page_size", request.getPage_size());
            }
            String jsonRequest = JSON.toJSONString(requestMap);
            log.debug("\u805a\u6c34\u6f6d\u4ed3\u5e93\u67e5\u8be2\u63a5\u53e3 - \u8bf7\u6c42\u6570\u636e: {}", (Object)jsonRequest);
            JushuitanBaseResponse baseResponse = this.jstService.getSellerItem(jsonRequest, "/open/wms/partner/query", pushRecordInterType, docId, docNo);
            log.debug("\u805a\u6c34\u6f6d\u4ed3\u5e93\u67e5\u8be2\u63a5\u53e3 - \u54cd\u5e94: {}", (Object)baseResponse);
            WarehouseQueryResponse response = this.convertToWarehouseQueryResponse(baseResponse);
            if (response.isSuccess() && response.getData() != null && !CollectionUtils.isEmpty(((WarehouseQueryResponse.WarehouseQueryData)response.getData()).getDatas())) {
                log.info("\u805a\u6c34\u6f6d\u4ed3\u5e93\u67e5\u8be2\u63a5\u53e3 - \u67e5\u8be2\u6210\u529f | \u4ed3\u5e93\u6570\u91cf: {}", (Object)((WarehouseQueryResponse.WarehouseQueryData)response.getData()).getDatas().size());
            } else if (response.isSuccess()) {
                log.info("\u805a\u6c34\u6f6d\u4ed3\u5e93\u67e5\u8be2\u63a5\u53e3 - \u67e5\u8be2\u6210\u529f\u4f46\u65e0\u6570\u636e");
            }
            log.info("\u805a\u6c34\u6f6d\u4ed3\u5e93\u67e5\u8be2\u63a5\u53e3 - \u5904\u7406\u5b8c\u6210 | \u72b6\u6001: {}, \u54cd\u5e94\u7801: {}", (Object)(response.isSuccess() ? "\u6210\u529f" : "\u5931\u8d25"), (Object)response.getCode());
            return response;
        }
        catch (Exception e) {
            log.error("\u805a\u6c34\u6f6d\u4ed3\u5e93\u67e5\u8be2\u63a5\u53e3\u5f02\u5e38", (Throwable)e);
            throw new Exception("\u805a\u6c34\u6f6d\u4ed3\u5e93\u67e5\u8be2\u63a5\u53e3\u5931\u8d25: " + e.getMessage(), e);
        }
    }

    private WarehouseQueryResponse convertToWarehouseQueryResponse(JushuitanBaseResponse baseResponse) {
        if (baseResponse == null) {
            return null;
        }
        WarehouseQueryResponse response = new WarehouseQueryResponse();
        response.setCode(baseResponse.getCode());
        response.setMsg(baseResponse.getMsg());
        response.setRequest_id(baseResponse.getRequest_id());
        response.setMsg_type(baseResponse.getMsg_type());
        response.setAct(baseResponse.getAct());
        if (baseResponse.getData() != null) {
            try {
                String dataJson = JSON.toJSONString(baseResponse.getData());
                WarehouseQueryResponse.WarehouseQueryData warehouseData = (WarehouseQueryResponse.WarehouseQueryData)JSON.parseObject((String)dataJson, WarehouseQueryResponse.WarehouseQueryData.class);
                response.setData(warehouseData);
            }
            catch (Exception e) {
                log.warn("\u8f6c\u6362\u4ed3\u5e93\u67e5\u8be2\u54cd\u5e94\u6570\u636e\u5931\u8d25", (Throwable)e);
            }
        }
        return response;
    }

    private Map<String, Object> buildSupplierItemMap(SupplierRequest.SupplierItem item) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("supplier_code", item.getSupplier_code());
        map.put("name", item.getName());
        map.put("enabled", true);
        return map;
    }

    public JushuitaServiceImpl(OutsidePushRecordRepository outsidePushRecordRepository, JstService jstService) {
        this.outsidePushRecordRepository = outsidePushRecordRepository;
        this.jstService = jstService;
    }
}

