package com.elitesland.zhiyuan.openapi.outer.jushuitan.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.zhiyuan.openapi.outer.jushuitan.common.service.JstService;
import com.elitesland.zhiyuan.openapi.outer.jushuitan.config.JstProperties;
import com.elitesland.zhiyuan.openapi.outer.jushuitan.params.req.JstTryFunDTO;
import com.elitesland.zhiyuan.openapi.outer.jushuitan.params.req.PurchaseInboundListRequest;
import com.elitesland.zhiyuan.openapi.outer.jushuitan.params.req.WarehouseQueryRequest;
import com.elitesland.zhiyuan.openapi.outer.jushuitan.params.resp.JushuitanBaseResponse;
import com.elitesland.zhiyuan.openapi.outer.jushuitan.params.resp.PurchaseInboundResponse;
import com.elitesland.zhiyuan.openapi.outer.jushuitan.params.resp.WarehouseQueryResponse;
import com.elitesland.zhiyuan.openapi.outer.jushuitan.service.JushuitaService;
import com.elitesland.zhiyuan.openapi.outer.nc.exception.NcApiException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.io.IOException;
import java.net.URL;
import java.util.Map;

/**
 * Jst重试接口控制器
 *
 * @author duwh
 */
@RestController
@RequestMapping("/jst/retry")
@RequiredArgsConstructor
@Api(value = "JST重试接口", tags = {"JST重试接口"})
@Slf4j
public class JstRetryController {

    private final JstService jstService;
    private final JushuitaService jushuitaService;
    private final JstProperties jstProperties;

    @PostMapping("/tryFun")
    @ApiOperation("JST重试接口")
    public ApiResult<JushuitanBaseResponse> tryFun(@RequestBody JstTryFunDTO jstTryFunDTO, String url) throws IOException {
        URL uri = new URL(jstProperties.getServerUrl() + url);
        String rspStr = jstService.callApi(uri, jstTryFunDTO.getParams());
        if (!StringUtils.hasText(rspStr)) {
            throw new NcApiException("YST接口返回空响应");
        }
        try {
            // 解析JSON响应
            JushuitanBaseResponse response = JSON.parseObject(rspStr, JushuitanBaseResponse.class);
            if (response == null) {
                log.error("JST接口响应解析失败: {}", rspStr);
                return ApiResult.fail("JST接口响应解析失败");
            }
            // 检查响应状态
            if (!response.isSuccess()) {
                String errorMessage = response.getMsg();
                log.error("JST接口调用失败: {}", errorMessage);
                return ApiResult.fail(errorMessage);
            }
            log.info("JST接口调用成功");
            return ApiResult.ok(response);
        } catch (JSONException e) {
            log.error("JST接口响应JSON解析失败: {}", rspStr, e);
            return ApiResult.fail("JST接口响应格式错误");
        }
    }


    @PostMapping("/testPurchaseinCreatebatch")
    @ApiOperation("JST 采购入库 Test接口")
    public ApiResult<PurchaseInboundResponse> testPurchaseinCreatebatch(@RequestBody PurchaseInboundListRequest purchaseInboundListRequest, Long docId, String docNo) throws Exception {
        PurchaseInboundResponse rspStr = jushuitaService.purchaseinCreatebatch(purchaseInboundListRequest, docId, docNo);
        return ApiResult.ok(rspStr);
    }

    @PostMapping("/testWarehouseQuery")
    @ApiOperation("JST 仓库查询 Test接口")
    public ApiResult<WarehouseQueryResponse> testWarehouseQuery(@RequestBody(required = false) WarehouseQueryRequest warehouseQueryRequest, 
                                                               String pushRecordInterType, 
                                                               Long docId, 
                                                               String docNo) throws Exception {
        // 如果请求参数为空，创建默认参数
        if (warehouseQueryRequest == null) {
            warehouseQueryRequest = new WarehouseQueryRequest();
            warehouseQueryRequest.setPage_index(1);
            warehouseQueryRequest.setPage_size(30);
        }
        
        // 设置默认的推送记录接口类型
        if (!StringUtils.hasText(pushRecordInterType)) {
            pushRecordInterType = "JST_INV_WH_TO_SCM";
        }
        
        // 设置默认的文档信息
        if (docId == null) {
            docId = 0L;
        }
        if (!StringUtils.hasText(docNo)) {
            docNo = "TEST_" + System.currentTimeMillis();
        }
        
        log.info("仓库查询测试接口调用 - 参数: {}, 推送类型: {}, 文档ID: {}, 文档编号: {}", 
                JSON.toJSONString(warehouseQueryRequest), pushRecordInterType, docId, docNo);
        
        WarehouseQueryResponse response = jushuitaService.queryWarehouse(warehouseQueryRequest, pushRecordInterType, docId, docNo);
        
        log.info("仓库查询测试接口响应 - 状态: {}, 仓库数量: {}", 
                response.isSuccess() ? "成功" : "失败",
                response.getData() != null && response.getData().getDatas() != null ? response.getData().getDatas().size() : 0);
        
        return ApiResult.ok(response);
    }

}
