package com.elitesland.zhiyuan.openapi.outer.jushuitan.common.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.elitescloud.cloudt.sys.outlog.OutsidePushInter;
import com.elitescloud.cloudt.sys.outlog.param.PushRecordDTO;
import com.elitescloud.cloudt.sys.outlog.rpc.OutsidePushRecordRepository;
import com.elitesland.zhiyuan.openapi.outer.jushuitan.config.JstProperties;
import com.elitesland.zhiyuan.openapi.outer.jushuitan.exception.JstApiException;
import com.elitesland.zhiyuan.openapi.outer.jushuitan.params.resp.JushuitanBaseResponse;
import com.elitesland.zhiyuan.openapi.outer.jushuitan.params.resp.PurchaseInboundResponse;
import com.elitesland.zhiyuan.openapi.outer.jushuitan.spi.InvIdoJstCallback;
import com.elitesland.zhiyuan.openapi.outer.nc.exception.NcApiException;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.io.*;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.util.*;
import java.util.stream.Collectors;
import java.util.zip.GZIPInputStream;

@Slf4j
@Service
@RequiredArgsConstructor
// 配置文件动态刷新
@RefreshScope
public class JstService {

    private static final String SIGN_METHOD_MD5 = "md5";
    private static final String CHARSET_UTF8 = "utf-8";
    private static final String CONTENT_ENCODING_GZIP = "gzip";

    private final JstProperties jstProperties;
    private final OutsidePushRecordRepository outsidePushRecordRepository;

    @Autowired
    private ObjectProvider<InvIdoJstCallback> invIdoJstCallbackObjectProvider;


    public String getSellerItem(String param, String url) throws IOException {
        Map<String, String> params = new HashMap<String, String>();
        // 公共参数
        // params.put("app_key", appKey);
        params.put("app_key", jstProperties.getAppKey());
        // params.put("access_token", accessToken);
        params.put("access_token", jstProperties.getAccessToken());
        params.put("timestamp", String.valueOf(System.currentTimeMillis() / 1000));
        params.put("version", "2");
        params.put("charset", "utf-8");
        // 业务参数
//        params.put("biz", "{\"page_index\":\"1\",\"page_size\":\"50\"}");
        params.put("biz", param);
        // 签名参数
        // params.put("sign", signTopRequest(params, appSecret, SIGN_METHOD_MD5));
        params.put("sign", signTopRequest(params, jstProperties.getAppSecret(), SIGN_METHOD_MD5));
        // 调用API
        return callApi(new URL(jstProperties.getServerUrl() + url), params);
    }

    public JushuitanBaseResponse getSellerItem(String param, String url, String pushRecordInterType, Long docId, String docNo) throws IOException {
        String appKey = jstProperties.getAppKey();
        String appSecret = jstProperties.getAppSecret();
        String accessToken = jstProperties.getAccessToken();
        // 调用API
        return getSellerItem(appKey, appSecret, accessToken, param, url, pushRecordInterType, docId, docNo);
    }

    public JushuitanBaseResponse getSellerItem(String appKey, String appSecret, String accessToken, String param, String url, String pushRecordInterType, Long docId, String docNo) throws IOException {
        // todo 后面删除掉
        appKey = jstProperties.getAppKey();
        appSecret = jstProperties.getAppSecret();
        accessToken = jstProperties.getAccessToken();
        // Assert.hasText(appKey, "appKey can not be null");
        // Assert.hasText(appSecret, "appSecret can not be null");
        // Assert.hasText(accessToken, "accessToken can not be null");
        Map<String, String> params = new HashMap<String, String>();
        // 公共参数
        // params.put("app_key", appKey);
        params.put("app_key", appKey);
        // params.put("access_token", accessToken);
        params.put("access_token", accessToken);
        params.put("timestamp", String.valueOf(System.currentTimeMillis() / 1000));
        params.put("version", "2");
        params.put("charset", "utf-8");
        // 业务参数
//        params.put("biz", "{\"page_index\":\"1\",\"page_size\":\"50\"}");
        params.put("biz", param);
        // 签名参数
        // params.put("sign", signTopRequest(params, appSecret, SIGN_METHOD_MD5));
        params.put("sign", signTopRequest(params, appSecret, SIGN_METHOD_MD5));
        // 调用API
        return callApi(new URL(jstProperties.getServerUrl() + url), params, pushRecordInterType, docId, docNo);
    }

    /**
     * 转换基础响应为采购入库响应
     */
    public static PurchaseInboundResponse convertToPurchaseInboundResponse(JushuitanBaseResponse baseResponse) {
        if (baseResponse == null) {
            return null;
        }

        PurchaseInboundResponse response = new PurchaseInboundResponse();
        response.setCode(baseResponse.getCode());
        response.setMsg(baseResponse.getMsg());
        response.setRequest_id(baseResponse.getRequest_id());
        response.setMsg_type(baseResponse.getMsg_type());
        response.setAct(baseResponse.getAct());
        // response.setCookie(baseResponse.getCookie());

        // 转换data部分
        if (baseResponse.getData() != null) {
            try {
                // 将data转换为JSON字符串再解析为List<PurchaseInboundData>
                String dataJson = JSON.toJSONString(baseResponse.getData());
                List<PurchaseInboundResponse.PurchaseInboundData> purchaseData = JSON.parseArray(dataJson, PurchaseInboundResponse.PurchaseInboundData.class);
                response.setData(purchaseData);
            } catch (Exception e) {
                log.warn("转换采购入库响应数据失败", e);
            }
        }

        return response;
    }


    /**
     * 转换基础响应采购退货响应
     */
    public static PurchaseInboundResponse convertToPurchaseReturnResponse(JushuitanBaseResponse baseResponse) {
        if (baseResponse == null) {
            return null;
        }

        PurchaseInboundResponse response = new PurchaseInboundResponse();
        response.setCode(baseResponse.getCode());
        response.setMsg(baseResponse.getMsg());
        response.setRequest_id(baseResponse.getRequest_id());
        response.setMsg_type(baseResponse.getMsg_type());
        response.setAct(baseResponse.getAct());
        // response.setCookie(baseResponse.getCookie());

        // 转换data部分
        if (baseResponse.getData() != null) {
            try {
                // 将data转换为JSON字符串再解析为List<PurchaseInboundData>
                String dataJson = JSON.toJSONString(baseResponse.getData());
                List<PurchaseInboundResponse.PurchaseInboundData> purchaseData = JSON.parseArray(dataJson, PurchaseInboundResponse.PurchaseInboundData.class);
                response.setData(purchaseData);
            } catch (Exception e) {
                log.warn("转换采购入库响应数据失败", e);
            }
        }

        return response;
    }

    /**
     * 对TOP请求进行签名。
     */
    private String signTopRequest(Map<String, String> params, String secret, String signMethod) throws IOException {
        // 第一步：检查参数是否已经排序
        String[] keys = params.keySet().toArray(new String[0]);
        Arrays.sort(keys);

        // 第二步：把所有参数名和参数值串在一起
        StringBuilder query = new StringBuilder();
        if (SIGN_METHOD_MD5.equals(signMethod)) {
            query.append(secret);
        }
        for (String key : keys) {
            String value = params.get(key);
            if (isNotEmpty(key) && isNotEmpty(value)) {
                query.append(key).append(value);
            }
        }
        return createSign(query.toString());
    }

    /**
     * 生成新sign
     *
     * @param str 字符串
     * @return String
     */
    private String createSign(String str) {
        if (str == null || str.length() == 0) {
            return null;
        }
        char[] hexDigits = {'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        try {
            MessageDigest mdTemp = MessageDigest.getInstance(SIGN_METHOD_MD5);
            mdTemp.update(str.getBytes("UTF-8"));

            byte[] md = mdTemp.digest();
            int j = md.length;
            char[] buf = new char[j * 2];
            int k = 0;
            int i = 0;
            while (i < j) {
                byte byte0 = md[i];
                buf[k++] = hexDigits[byte0 >>> 4 & 0xf];
                buf[k++] = hexDigits[byte0 & 0xf];
                i++;
            }
            return new String(buf);
        } catch (Exception e) {
            return null;
        }
    }

    public String callApi(URL url, Map<String, String> params) throws IOException {
        String query = buildQuery(params, CHARSET_UTF8);
        byte[] content = {};
        if (query != null) {
            content = query.getBytes(CHARSET_UTF8);
        }

        HttpURLConnection conn = null;
        OutputStream out = null;
        String rsp = null;
        try {
            conn = (HttpURLConnection) url.openConnection();
            conn.setRequestMethod("POST");
            conn.setDoInput(true);
            conn.setDoOutput(true);
            conn.setRequestProperty("Host", url.getHost());
            conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded;charset=" + CHARSET_UTF8);
            out = conn.getOutputStream();
            out.write(content);
            rsp = getResponseAsString(conn);
        } finally {
            if (out != null) {
                out.close();
            }
            if (conn != null) {
                conn.disconnect();
            }
        }

        return rsp;
    }

    public JushuitanBaseResponse callApi(URL url, Map<String, String> params, String pushRecordInterType, Long docId, String docNo) throws IOException {
        if (!jstProperties.getEnabled()) {
            log.warn("JST接口未启用，跳过调用");
            JushuitanBaseResponse response = new JushuitanBaseResponse();
            response.setCode(99999);
            response.setMsg("JST接口未启用");
            return response;
        }
        PushRecordDTO pushRecordDTO = new PushRecordDTO();
        pushRecordDTO.setInterType(pushRecordInterType);
        pushRecordDTO.setDocNo(docNo);
        pushRecordDTO.setDocId(docId);
        pushRecordDTO.setReqSuccess(false);
        pushRecordDTO.setReqBody(params);
        String query = buildQuery(params, CHARSET_UTF8);
        byte[] content = {};
        if (query != null) {
            content = query.getBytes(CHARSET_UTF8);
        }

        HttpURLConnection conn = null;
        OutputStream out = null;

        try {
            conn = (HttpURLConnection) url.openConnection();
            conn.setRequestMethod("POST");
            conn.setDoInput(true);
            conn.setDoOutput(true);
            conn.setRequestProperty("Host", url.getHost());
            conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded;charset=" + CHARSET_UTF8);
            out = conn.getOutputStream();
            out.write(content);
            String rspStr = getResponseAsString(conn);
            if (!StringUtils.hasText(rspStr)) {
                throw new NcApiException("YST接口返回空响应");
            }
            try {
                // 解析JSON响应
                JushuitanBaseResponse response = JSON.parseObject(rspStr, JushuitanBaseResponse.class);
                pushRecordDTO.setRespBody(response);
                if (response == null) {
                    log.error("JST接口响应解析失败: {}", rspStr);
                    throw new NcApiException("JST接口响应解析失败");
                }
                log.info("JST接口响应解析结果: 响应编码={}, 响应消息={}, 消息类型={}, 请求ID={}",
                        response.getCode(), response.getMsg(), response.getMsg_type(), response.getRequest_id());

                // // 不抛异常了
                // if (true) {
                //     return response;
                // }
                // 检查响应状态
                if (!response.isSuccess()) {
                    String errorMessage = response.getMsg();
                    pushRecordDTO.setErrorMsg(errorMessage);
                    log.error("JST接口调用失败: {}", errorMessage);
                    throw new JstApiException(response.getCode(), errorMessage,
                            response.getMsg_type(), response.getRequest_id());
                }
                // 采购入库返回信息
                /**
                 {
                 "code": 0,
                 "msg": null,
                 "request_id": null,
                 "msg_type": "string",
                 "act": null,
                 "data":
                 [
                 {
                 "pack_ids": null,
                 "external_id": "SSY012510300027",
                 "message": "公司：30023551 不存在",
                 "is_success": false,
                 "io_id": 0
                 }
                 ],
                 "success": true,
                 "tooFrequent": false
                 }
                 */
                /**
                 {
                 "msg" : null,
                 "code" : 0,
                 "data" : [ {
                 "pack_ids" : null,
                 "external_id" : "SSY012510300027",
                 "message" : "供应商编码、采购单号、预约单号必须有一个值",
                 "is_success" : false,
                 "io_id" : 0
                 } ],
                 "msg_type" : "string",
                 "request_id" : null
                 }
                 */
                if (OutsidePushInter.INV_IDO_SYNC_TO_JST.name().equals(pushRecordInterType)) {
                    // 4. 转换为PurchaseInboundResponse
                    PurchaseInboundResponse purchaseInboundResponse = convertToPurchaseInboundResponse(response);
                    // 5. 业务状态检查
                    if (purchaseInboundResponse.isSuccess() && purchaseInboundResponse.getData() != null && !CollectionUtils.isEmpty(purchaseInboundResponse.getData())) {
                        List<String> failedMessage = purchaseInboundResponse.getData().stream()
                                .filter(data -> !Boolean.TRUE.equals(data.getIs_success()))
                                .map(PurchaseInboundResponse.PurchaseInboundData::getMessage)
                                .collect(Collectors.toList());

                        if (!failedMessage.isEmpty()) {
                            String errorMsg = String.join(",", failedMessage);
                            log.warn("聚水潭采购入库批量创建接口 - 部分入库单创建失败 | 失败的外部单号: {}",
                                    errorMsg);
                            pushRecordDTO.setReqSuccess(false);
                            pushRecordDTO.setErrorMsg(errorMsg);
                            outsidePushRecordRepository.savePushRecord(pushRecordDTO);
                            return response;
                        }
                    }
                    // 回调
                    for (InvIdoJstCallback invIdoJstCallback : invIdoJstCallbackObjectProvider) {
                        invIdoJstCallback.callback(purchaseInboundResponse);
                    }
                }
                pushRecordDTO.setReqSuccess(true);
                outsidePushRecordRepository.savePushRecord(pushRecordDTO);
                log.info("JST接口调用成功");
                return response;
            } catch (JSONException e) {
                log.error("JST接口响应JSON解析失败: {}", rspStr, e);
                pushRecordDTO.setErrorMsg(e.getMessage());
                pushRecordDTO.setReqSuccess(false);
                outsidePushRecordRepository.savePushRecord(pushRecordDTO);
                throw new JstApiException("JST接口响应格式错误: " + e.getMessage(), e);
            }
        } catch (Exception e) {
            log.error("jst推送失败", e);
            pushRecordDTO.setErrorMsg(e.getMessage());
            pushRecordDTO.setReqSuccess(false);
            outsidePushRecordRepository.savePushRecord(pushRecordDTO);
            throw new JstApiException(9999, e.getMessage(),
                    "ee", "eee");
        } finally {
            if (out != null) {
                out.close();
            }
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    private String buildQuery(Map<String, String> params, String charset) throws IOException {
        if (params == null || params.isEmpty()) {
            return null;
        }

        StringBuilder query = new StringBuilder();
        Set<Map.Entry<String, String>> entries = params.entrySet();
        boolean hasParam = false;

        for (Map.Entry<String, String> entry : entries) {
            String name = entry.getKey();
            String value = entry.getValue();
            // 忽略参数名或参数值为空的参数
            if (isNotEmpty(name) && isNotEmpty(value)) {
                if (hasParam) {
                    query.append("&");
                } else {
                    hasParam = true;
                }

                query.append(name).append("=").append(URLEncoder.encode(value, charset));
            }
        }

        return query.toString();
    }

    private String getResponseAsString(HttpURLConnection conn) throws IOException {
        String charset = getResponseCharset(conn.getContentType());
        if (conn.getResponseCode() < 400) {
            String contentEncoding = conn.getContentEncoding();
            if (CONTENT_ENCODING_GZIP.equalsIgnoreCase(contentEncoding)) {
                return getStreamAsString(new GZIPInputStream(conn.getInputStream()), charset);
            } else {
                return getStreamAsString(conn.getInputStream(), charset);
            }
        } else {// Client Error 4xx and Server Error 5xx
            throw new IOException(conn.getResponseCode() + " " + conn.getResponseMessage());
        }
    }

    private String getStreamAsString(InputStream stream, String charset) throws IOException {
        try {
            Reader reader = new InputStreamReader(stream, charset);
            StringBuilder response = new StringBuilder();

            final char[] buff = new char[1024];
            int read = 0;
            while ((read = reader.read(buff)) > 0) {
                response.append(buff, 0, read);
            }

            return response.toString();
        } finally {
            if (stream != null) {
                stream.close();
            }
        }
    }

    private String getResponseCharset(String ctype) {
        String charset = CHARSET_UTF8;

        if (isNotEmpty(ctype)) {
            String[] params = ctype.split(";");
            for (String param : params) {
                param = param.trim();
                if (param.startsWith("charset")) {
                    String[] pair = param.split("=", 2);
                    if (pair.length == 2) {
                        if (isNotEmpty(pair[1])) {
                            charset = pair[1].trim();
                        }
                    }
                    break;
                }
            }
        }

        return charset;
    }

    private boolean isNotEmpty(String value) {
        int strLen;
        if (value == null || (strLen = value.length()) == 0) {
            return false;
        }
        for (int i = 0; i < strLen; i++) {
            if ((Character.isWhitespace(value.charAt(i)) == false)) {
                return true;
            }
        }
        return false;
    }

}
