package com.elitesland.zhiyuan.openapi.outer.jackyun.params;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

@Data
public class VendCreateRequest {
    private String docNo;

    private Long docId;
    // 基础信息
    @JsonProperty("code")
    private String code; // 编码 (必填)
    @JsonProperty("name")
    private String name; // 名称 (更新时必填)
    @JsonProperty("classId")
    private Integer classId; // 分类id
    @JsonProperty("className")
    private String className; // 分类名称 (必填)
    @JsonProperty("abbreviation")
    private String abbreviation; // 简称
    @JsonProperty("countryName")
    private String countryName; // 国家
    @JsonProperty("provinceName")
    private String provinceName; // 省
    @JsonProperty("cityName")
    private String cityName; // 市
    @JsonProperty("townName")
    private String townName; // 区
    @JsonProperty("streetName")
    private String streetName; // 街道名称
    @JsonProperty("address")
    private String address; // 地址
    @JsonProperty("postcode")
    private String postcode; // 邮编
    @JsonProperty("email")
    private String email; // 电子邮件
    @JsonProperty("website")
    private String website; // 网址
    @JsonProperty("assistantCode")
    private String assistantCode; // 助记码
    @JsonProperty("developDate")
    private String developDate; // 发展日期 (格式: yyyy-MM-dd)
    @JsonProperty("leader")
    private String leader; // 负责人
    @JsonProperty("tel")
    private String tel; // 电话
    @JsonProperty("fax")
    private String fax; // 传真
    @JsonProperty("memo")
    private String memo; // 备注
    @JsonProperty("businessScope")
    private String businessScope; // 经营范围
    @JsonProperty("flagData")
    private String flagData; // 标记Id集合
    @JsonProperty("levelCode")
    private String levelCode; // 等级 (01:一级, 02:二级, 03:三级)
    @JsonProperty("classCode")
    private String classCode; // 分类编号 (创建时必填)

    // 业务配置
    @JsonProperty("arrivePeriod")
    private Integer arrivePeriod; // 交付周期(天)
    @JsonProperty("remindMsg")
    private String remindMsg; // 特别提醒
    @JsonProperty("orderIndex")
    private Integer orderIndex; // 序号
    @JsonProperty("goodsSupplyAddress")
    private String goodsSupplyAddress; // 货源地
    @JsonProperty("advancePayPercent")
    private BigDecimal advancePayPercent; // 默认预付款比例
    @JsonProperty("settType")
    private String settType; // 默认结算方式
    @JsonProperty("paymentMethodName")
    private String paymentMethodName; // 默认结算账期
    @JsonProperty("currencyName")
    private String currencyName; // 默认采购币种
    @JsonProperty("logisticName")
    private String logisticName; // 默认物流公司
    @JsonProperty("defaultInvoiceType")
    private String defaultInvoiceType; // 默认开票
    @JsonProperty("warehouseCode")
    private String warehouseCode; // 默认供应商虚拟仓仓库编号

    // 公司信息
    @JsonProperty("generalManager")
    private String generalManager; // 总经理
    @JsonProperty("registeredCapital")
    private String registeredCapital; // 注册资本
    @JsonProperty("legalPerson")
    private String legalPerson; // 法定代表人
    @JsonProperty("taxNumber")
    private String taxNumber; // 开票税号
    @JsonProperty("qualificationDueDate")
    private String qualificationDueDate; // 资质到期日期
    @JsonProperty("certificationSystem")
    private String certificationSystem; // 认证体系
    @JsonProperty("plantArea")
    private String plantArea; // 厂房面积
    @JsonProperty("storageArea")
    private String storageArea; // 仓储面积
    @JsonProperty("numberOfEmployees")
    private String numberOfEmployees; // 员工人数
    @JsonProperty("annualOutputValue")
    private String annualOutputValue; // 年产值
    @JsonProperty("mainProductsAndServices")
    private String mainProductsAndServices; // 主要产品及服务
    @JsonProperty("mainEquipmentAndProcess")
    private String mainEquipmentAndProcess; // 主要设备及工艺
    @JsonProperty("monthlySupplyCapacity")
    private String monthlySupplyCapacity; // 月供货能力
    @JsonProperty("supplyProportion")
    private String supplyProportion; // 供货占比
    @JsonProperty("qualifiedRateOfSupply")
    private String qualifiedRateOfSupply; // 供货合格率
    @JsonProperty("estimatedProduction")
    private BigDecimal estimatedProduction; // 预估产能
    @JsonProperty("isSupportDistribution")
    private Integer isSupportDistribution; // 支持代发(1:是, 0:否)

    // 客户信息
    @JsonProperty("majorCustomerGroups")
    private String majorCustomerGroups; // 主要客户群体

    // 自定义字段 (field1-field16)
    @JsonProperty("field1")
    private String field1;
    @JsonProperty("field2")
    private String field2;
    @JsonProperty("field3")
    private String field3;
    @JsonProperty("field4")
    private String field4;
    @JsonProperty("field5")
    private String field5;
    @JsonProperty("field6")
    private String field6;
    @JsonProperty("field7")
    private String field7;
    @JsonProperty("field8")
    private String field8;
    @JsonProperty("field9")
    private String field9;
    @JsonProperty("field10")
    private String field10;
    @JsonProperty("field11")
    private String field11;
    @JsonProperty("field12")
    private String field12;
    @JsonProperty("field13")
    private String field13;
    @JsonProperty("field14")
    private String field14;
    @JsonProperty("field15")
    private String field15;
    @JsonProperty("field16")
    private String field16;

    // 供应商收款账户列表
    @JsonProperty("vendPayAccountList")
    private List<VendPayAccount> vendPayAccountList;

    // 供应商联系人列表
    @JsonProperty("vendLinkmanList")
    private List<VendLinkman> vendLinkmanList;

    // 内部类：供应商收款账户
    @Data
    public static class VendPayAccount {
        @JsonProperty("companyId")
        private String companyId; // 公司id (创建时必填)
        @JsonProperty("companyName")
        private String companyName; // 公司名称 (创建时必填)
        @JsonProperty("accountTypeCode")
        private String accountTypeCode; // 账户类型编码 (创建时必填)
        @JsonProperty("accountTypeName")
        private String accountTypeName; // 账户类型名称 (创建时必填)
        @JsonProperty("bankbranch")
        private String bankbranch; // 付款开户行 (创建时必填)
        @JsonProperty("bankacct")
        private String bankacct; // 银行账号 (创建时必填)
        @JsonProperty("accName")
        private String accName; // 账户名称 (创建时必填)
        @JsonProperty("isDefault")
        private String isDefault; // 是否默认账户 (0:否, 1:是)
        @JsonProperty("bankName")
        private String bankName; // 银行名称
    }

    // 内部类：供应商联系人
    @Data
    public static class VendLinkman {
        @JsonProperty("linkman")
        private String linkman; // 联系人 (创建时必填)
        @JsonProperty("position")
        private String position; // 职务
        @JsonProperty("linktel")
        private String linktel; // 联系电话
        @JsonProperty("qq")
        private String qq; // qq
        @JsonProperty("wechat")
        private String wechat; // 微信
        @JsonProperty("email")
        private String email; // 电子邮件
        @JsonProperty("memo")
        private String memo; // 备注
        @JsonProperty("companyCode")
        private String companyCode; // 公司编码
        @JsonProperty("departCode")
        private String departCode; // 部门编码


    }
    // 必填字段校验
    public void validate() {
        if (code == null || code.trim().isEmpty()) throw new IllegalArgumentException("供应商编码不能为空");
        if (name == null || name.trim().isEmpty()) throw new IllegalArgumentException("供应商名称不能为空");
    }

}
