package com.elitesland.zhiyuan.openapi.outer.jackyun.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.elitescloud.cloudt.sys.outlog.rpc.OutsidePushRecordRepository;
import com.elitesland.zhiyuan.openapi.outer.jackyun.data.JackyunResponse;
import com.elitesland.zhiyuan.openapi.outer.jackyun.data.bizdata.core.BaseRequestBizData;
import com.elitesland.zhiyuan.openapi.outer.jackyun.data.bizdata.erp.erpgoodskuimportbatch.ErpGoodsSkuimPortBatchRequestBizData;
import com.elitesland.zhiyuan.openapi.outer.jackyun.data.bizdata.erp.erpgoodskuimportbatch.ErpGoodsSkuimPortBatchResponseBizData;
import com.elitesland.zhiyuan.openapi.outer.jackyun.data.bizdata.erp.erpstockcreateandstockin.ErpStockCreateAndStockInRequestBizData;
import com.elitesland.zhiyuan.openapi.outer.jackyun.data.bizdata.erp.erpstockcreateandstockin.ErpStockCreateAndStockInResponseBizData;
import com.elitesland.zhiyuan.openapi.outer.jackyun.data.bizdata.erp.erpstoragegoodsdocinv2.ErpStorageGoodsDocInV2RequestBizData;
import com.elitesland.zhiyuan.openapi.outer.jackyun.data.bizdata.erp.erpstoragegoodsdocinv2.ErpStorageGoodsDocInV2ResponseBizData;
import com.elitesland.zhiyuan.openapi.outer.jackyun.data.bizdata.erp.erpstoragegoodsdocoutv2.ErpStorageGoodsDocOutV2RequestBizData;
import com.elitesland.zhiyuan.openapi.outer.jackyun.data.bizdata.erp.erpstoragegoodsdocoutv2.ErpStorageGoodsDocOutV2ResponseBizData;
import com.elitesland.zhiyuan.openapi.outer.jackyun.data.bizdata.erp.erpvendcreatev2.ErpVendCreateV2RequestBizData;
import com.elitesland.zhiyuan.openapi.outer.jackyun.data.bizdata.erp.erpvendcreatev2.ErpVendCreateV2ResponseBizData;
import com.elitesland.zhiyuan.openapi.outer.jackyun.data.core.ApiEnum;
import com.elitesland.zhiyuan.openapi.outer.jackyun.params.MaterialCreateRequest;
import com.elitesland.zhiyuan.openapi.outer.jackyun.params.VendCreateRequest;
import com.elitesland.zhiyuan.openapi.outer.jackyun.service.JackyunOpenClientService;
import com.elitesland.zhiyuan.openapi.outer.jackyun.service.JackyunService;
import com.elitesland.zhiyuan.openapi.outer.jackyun.util.JsonUtils;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

@Slf4j
@Service
@RequiredArgsConstructor
// 配置文件动态刷新
@RefreshScope
public class JackyunServiceImpl implements JackyunService {

    /**
     * 请求吉客云开放平台服务
     */
    private final JackyunOpenClientService clientService;

    private final OutsidePushRecordRepository outsidePushRecordRepository;


    /**
     * 物料创建请求接口
     *
     * @param materialCreateRequest
     * @return
     */
    @Override
    public JackyunResponse createMaterial(MaterialCreateRequest materialCreateRequest, String pushRecordInterType, Long docId, String docNo) {
        // 记录请求开始
        log.info("开始创建物料，请求参数: [goodsNo={}] [goodsName={}]",
                materialCreateRequest.getGoodsNo(), materialCreateRequest.getGoodsName());
        // 业务校验
        if (StringUtils.isBlank(materialCreateRequest.getGoodsNo())) {
            throw new IllegalArgumentException("货品编码 goodsNo 不能为空");
        }
        if (StringUtils.isBlank(materialCreateRequest.getGoodsName())) {
            throw new IllegalArgumentException("货品名称 goodsName 不能为空");
        }

        List<BaseRequestBizData> erpGoodsSkuimPortBatchRequestBizDataList = new ArrayList<>();
        ErpGoodsSkuimPortBatchRequestBizData requestBizData1 = new ErpGoodsSkuimPortBatchRequestBizData();
        requestBizData1.setGoodsName(materialCreateRequest.getGoodsName());
        requestBizData1.setGoodsNo(materialCreateRequest.getGoodsNo());
        requestBizData1.setOutSkuCode(materialCreateRequest.getGoodsNo());
        requestBizData1.setUnitName(materialCreateRequest.getUnitName());
        requestBizData1.setDescript(materialCreateRequest.getDescript());
        requestBizData1.setSkuName(materialCreateRequest.getSkuName());
        erpGoodsSkuimPortBatchRequestBizDataList.add(requestBizData1);
        // 开放平台应用信息
        JackyunResponse jackyunResponse = clientService.callBatchApi(ApiEnum.ERPGOODSSKUIMPORTBATCH.getValue(), erpGoodsSkuimPortBatchRequestBizDataList, pushRecordInterType, docId, docNo);
        List<ErpGoodsSkuimPortBatchResponseBizData> responseBizData = null;
        log.debug("物料创建接口调用成功，请求参数: [{}], 响应内容: [{}]",
                erpGoodsSkuimPortBatchRequestBizDataList, jackyunResponse);
        if (jackyunResponse.isSuccess()) {
            JSONObject response = JsonUtils.deJson(jackyunResponse.toJson(), JSONObject.class);
            responseBizData = response.getJSONObject("result").getJSONArray("data").toJavaList(ErpGoodsSkuimPortBatchResponseBizData.class);
        }
        return jackyunResponse;
    }


    /**
     * 供应商更新创建
     */
    @Override
    public JackyunResponse createVendor(VendCreateRequest request, String pushRecordInterType, Long docId, String docNo) {

        // 记录请求开始
        log.info("开始创建供应商，请求参数: [code={}] [name={}]",
                request.getCode(), request.getName());

        ErpVendCreateV2RequestBizData requestBizData = new ErpVendCreateV2RequestBizData();
        requestBizData.setLeader("测试工作人");
        requestBizData.setCode(request.getCode());
        requestBizData.setClassCode(request.getCode());
        requestBizData.setName(request.getName());
        requestBizData.setClassName(request.getClassName());

        JackyunResponse jackyunResponse = getJackyunResponse(ApiEnum.ERPVENDCREATEV2.getValue(), requestBizData, pushRecordInterType, docId, docNo);
        ErpVendCreateV2ResponseBizData responseBizData = null;

        log.debug("供应商创建接口调用成功，请求参数: [{}], 响应内容: [{}]", requestBizData, jackyunResponse);

        if (jackyunResponse.isSuccess()) {
            JSONObject response = JsonUtils.deJson(jackyunResponse.toJson(), JSONObject.class);
            responseBizData = response.getJSONObject("result").getJSONObject("data").toJavaObject(ErpVendCreateV2ResponseBizData.class);
        }
        return jackyunResponse;
    }

    /**
     * 发送接口请求并获取数据
     *
     * @param method         Api方法名
     * @param requestBizData 请求参数
     * @return 请求的返回数据
     */
    public JackyunResponse getJackyunResponse(String method, BaseRequestBizData requestBizData, String pushRecordInterType, Long docId, String docNo) {

        JackyunResponse jackyunResponse = this.clientService.callApi(method, requestBizData, pushRecordInterType, docId, docNo);
        System.out.println(jackyunResponse.toJson());
        return jackyunResponse;
    }

    /**
     * 入库单查询接口
     */
    public void erpStorageGoodsDocInV2() {
        ErpStorageGoodsDocInV2RequestBizData requestBizData = new ErpStorageGoodsDocInV2RequestBizData();
        requestBizData.setPageSize(10);
        requestBizData.setSelelctFields("recId,goodsdocNo");
        requestBizData.setGoodsDocNo("CRK202405070001");
        JackyunResponse jackyunResponse = getJackyunResponse(ApiEnum.ERPSTORAGEGOODSDOCINV2.getValue(), requestBizData,"",0L,"");
        List<ErpStorageGoodsDocInV2ResponseBizData> responseBizData = null;

        if (jackyunResponse.isSuccess()) {
            JSONObject response = JsonUtils.deJson(jackyunResponse.toJson(), JSONObject.class);
            responseBizData = response.getJSONObject("result").getJSONArray("data").toJavaList(ErpStorageGoodsDocInV2ResponseBizData.class);
        }
        System.out.println(JsonUtils.toJson(responseBizData));
    }

    /**
     * 分页查询出库单
     */
    public void erpStorageGoodsDocOutV2() {
        ErpStorageGoodsDocOutV2RequestBizData requestBizData = new ErpStorageGoodsDocOutV2RequestBizData();
        requestBizData.setPageSize(10);
        requestBizData.setSelelctFields("recId,goodsdocNo");
        JackyunResponse jackyunResponse = getJackyunResponse(ApiEnum.ERPSTORAGEGOODSDOCOUTV2.getValue(), requestBizData,"",0L,"");
        List<ErpStorageGoodsDocOutV2ResponseBizData> responseBizData = null;

        if (jackyunResponse.isSuccess()) {
            JSONObject response = JsonUtils.deJson(jackyunResponse.toJson(), JSONObject.class);
            responseBizData = response.getJSONObject("result").getJSONArray("data").toJavaList(ErpStorageGoodsDocOutV2ResponseBizData.class);
        }
        System.out.println(JsonUtils.toJson(responseBizData));
    }

    /**
     * 创建入库申请单并入库
     */
    public JackyunResponse erpStockCreateAndStockIn(ErpStockCreateAndStockInRequestBizData requestBizData, String pushRecordInterType, Long docId, String docNo) {
        requestBizData.setPageSize(10);
        JackyunResponse jackyunResponse = getJackyunResponse(ApiEnum.ERPSTORAGESTOCKINCREATE.getValue(), requestBizData,pushRecordInterType,docId,docNo);
        List<ErpStockCreateAndStockInResponseBizData> responseBizData = null;

        if (jackyunResponse.isSuccess()) {
            JSONObject response = JsonUtils.deJson(jackyunResponse.toJson(), JSONObject.class);
            responseBizData = response.getJSONObject("result").getJSONArray("data").toJavaList(ErpStockCreateAndStockInResponseBizData.class);
        }
        return jackyunResponse;
    }

}