package com.elitesland.zhiyuan.openapi.outer.jushuitan.params.req;




import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;
import java.util.List;

/**
 * ClassName: OrderQueryRequest
 * Description:
 *
 * @author wz
 * @date 2024/5/14 16:36
 */
@Data
public class NoTaoOrderQueryRequest {

    @ApiModelProperty("店铺编号")
    private Integer shop_id;
    @ApiModelProperty("shop_id为0且is_offline_shop为true查询线下店铺单据")
    private boolean is_offline_shop;
    @ApiModelProperty("起始时间，和结束时间必须同时存在，时间间隔不能超过七天，与线上单号，内部单号不能同时为空;tips:用时间条件查询由于查询中数据存在变动的可能会由于排序问题引发分页查询漏单的问题，建议使用ts时间戳增量查询的方式")
    private String modified_begin;
    @ApiModelProperty("结束时间，和起始时间必须同时存在，时间间隔不能超过七天，与线上单号，内部单号不能同时为空")
    private String modified_end;
    @ApiModelProperty("(0:修改时间modified，2:订单日期order_date，3:发货时间send_date；非必填，默认0)")
    private Integer date_type;
    @ApiModelProperty("订单状态：待付款：WaitPay；发货中：Delivering；被合并：Merged；异常：Question；被拆分：Split；等供销商|外仓发货：WaitOuterSent；已付款待审核：WaitConfirm；已客审待财审：WaitFConfirm；已发货：Sent；取消：Cancelled")
    private String status;
    @ApiModelProperty("第几页，从1开始")
    private String page_index;
    @ApiModelProperty("最每页多少条，最大50条")
    private String page_size;
    @ApiModelProperty("ts时间戳，sql server中的行版本号，该字段查询防止分页过程中漏单。查询条件值是大于等于的关系")
    private String start_ts;
    @ApiModelProperty("是否查询总条数默认true，如果使用start_ts查询，该值传false否则影响查询效率")
    private boolean is_get_total;
    @ApiModelProperty("是否查询跨境财务信息")
    private boolean is_get_cbfinance;

    @ApiModelProperty("内部单号")
    private List<String> o_ids;

    //开始时间-结束时间
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern="yyyy-MM-dd HH:mm:ss")
    private LocalDateTime fromdt;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern="yyyy-MM-dd HH:mm:ss")
    private LocalDateTime todt;

}
