/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.zhiyuan.openapi.outer.jackyun.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.elitescloud.cloudt.sys.outlog.rpc.OutsidePushRecordRepository;
import com.elitesland.zhiyuan.openapi.outer.jackyun.data.JackyunResponse;
import com.elitesland.zhiyuan.openapi.outer.jackyun.data.bizdata.core.BaseRequestBizData;
import com.elitesland.zhiyuan.openapi.outer.jackyun.data.bizdata.erp.erpgoodskuimportbatch.ErpGoodsSkuimPortBatchRequestBizData;
import com.elitesland.zhiyuan.openapi.outer.jackyun.data.bizdata.erp.erpgoodskuimportbatch.ErpGoodsSkuimPortBatchResponseBizData;
import com.elitesland.zhiyuan.openapi.outer.jackyun.data.bizdata.erp.erpstockcreateandstockin.ErpStockCreateAndStockInRequestBizData;
import com.elitesland.zhiyuan.openapi.outer.jackyun.data.bizdata.erp.erpstockcreateandstockin.ErpStockCreateAndStockInResponseBizData;
import com.elitesland.zhiyuan.openapi.outer.jackyun.data.bizdata.erp.erpstoragegoodsdocinv2.ErpStorageGoodsDocInV2RequestBizData;
import com.elitesland.zhiyuan.openapi.outer.jackyun.data.bizdata.erp.erpstoragegoodsdocinv2.ErpStorageGoodsDocInV2ResponseBizData;
import com.elitesland.zhiyuan.openapi.outer.jackyun.data.bizdata.erp.erpstoragegoodsdocoutv2.ErpStorageGoodsDocOutV2RequestBizData;
import com.elitesland.zhiyuan.openapi.outer.jackyun.data.bizdata.erp.erpstoragegoodsdocoutv2.ErpStorageGoodsDocOutV2ResponseBizData;
import com.elitesland.zhiyuan.openapi.outer.jackyun.data.bizdata.erp.erpvendcreatev2.ErpVendCreateV2RequestBizData;
import com.elitesland.zhiyuan.openapi.outer.jackyun.data.bizdata.erp.erpvendcreatev2.ErpVendCreateV2ResponseBizData;
import com.elitesland.zhiyuan.openapi.outer.jackyun.data.core.ApiEnum;
import com.elitesland.zhiyuan.openapi.outer.jackyun.params.MaterialCreateRequest;
import com.elitesland.zhiyuan.openapi.outer.jackyun.params.VendCreateRequest;
import com.elitesland.zhiyuan.openapi.outer.jackyun.service.JackyunOpenClientService;
import com.elitesland.zhiyuan.openapi.outer.jackyun.service.JackyunService;
import com.elitesland.zhiyuan.openapi.outer.jackyun.util.JsonUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Service;

@Service
@RefreshScope
public class JackyunServiceImpl
implements JackyunService {
    private static final Logger log = LoggerFactory.getLogger(JackyunServiceImpl.class);
    private final JackyunOpenClientService clientService;
    private final OutsidePushRecordRepository outsidePushRecordRepository;

    @Override
    public JackyunResponse createMaterial(MaterialCreateRequest materialCreateRequest, String pushRecordInterType, Long docId, String docNo) {
        log.info("\u5f00\u59cb\u521b\u5efa\u7269\u6599\uff0c\u8bf7\u6c42\u53c2\u6570: [goodsNo={}] [goodsName={}]", (Object)materialCreateRequest.getGoodsNo(), (Object)materialCreateRequest.getGoodsName());
        if (StringUtils.isBlank((CharSequence)materialCreateRequest.getGoodsNo())) {
            throw new IllegalArgumentException("\u8d27\u54c1\u7f16\u7801 goodsNo \u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)materialCreateRequest.getGoodsName())) {
            throw new IllegalArgumentException("\u8d27\u54c1\u540d\u79f0 goodsName \u4e0d\u80fd\u4e3a\u7a7a");
        }
        ArrayList<BaseRequestBizData> erpGoodsSkuimPortBatchRequestBizDataList = new ArrayList<BaseRequestBizData>();
        ErpGoodsSkuimPortBatchRequestBizData requestBizData1 = new ErpGoodsSkuimPortBatchRequestBizData();
        requestBizData1.setGoodsName(materialCreateRequest.getGoodsName());
        requestBizData1.setGoodsNo(materialCreateRequest.getGoodsNo());
        requestBizData1.setOutSkuCode(materialCreateRequest.getGoodsNo());
        requestBizData1.setUnitName(materialCreateRequest.getUnitName());
        requestBizData1.setDescript(materialCreateRequest.getDescript());
        requestBizData1.setSkuName(materialCreateRequest.getSkuName());
        erpGoodsSkuimPortBatchRequestBizDataList.add(requestBizData1);
        JackyunResponse jackyunResponse = this.clientService.callBatchApi(ApiEnum.ERPGOODSSKUIMPORTBATCH.getValue(), erpGoodsSkuimPortBatchRequestBizDataList, pushRecordInterType, docId, docNo);
        List responseBizData = null;
        log.debug("\u7269\u6599\u521b\u5efa\u63a5\u53e3\u8c03\u7528\u6210\u529f\uff0c\u8bf7\u6c42\u53c2\u6570: [{}], \u54cd\u5e94\u5185\u5bb9: [{}]", erpGoodsSkuimPortBatchRequestBizDataList, (Object)jackyunResponse);
        if (jackyunResponse.isSuccess()) {
            JSONObject response = JsonUtils.deJson(jackyunResponse.toJson(), JSONObject.class);
            responseBizData = response.getJSONObject("result").getJSONArray("data").toJavaList(ErpGoodsSkuimPortBatchResponseBizData.class);
        }
        return jackyunResponse;
    }

    @Override
    public JackyunResponse createVendor(VendCreateRequest request, String pushRecordInterType, Long docId, String docNo) {
        log.info("\u5f00\u59cb\u521b\u5efa\u4f9b\u5e94\u5546\uff0c\u8bf7\u6c42\u53c2\u6570: [code={}] [name={}]", (Object)request.getCode(), (Object)request.getName());
        ErpVendCreateV2RequestBizData requestBizData = new ErpVendCreateV2RequestBizData();
        requestBizData.setLeader("\u6d4b\u8bd5\u5de5\u4f5c\u4eba");
        requestBizData.setCode(request.getCode());
        requestBizData.setClassCode(request.getCode());
        requestBizData.setName(request.getName());
        requestBizData.setClassName(request.getClassName());
        JackyunResponse jackyunResponse = this.getJackyunResponse(ApiEnum.ERPVENDCREATEV2.getValue(), requestBizData, pushRecordInterType, docId, docNo);
        ErpVendCreateV2ResponseBizData responseBizData = null;
        log.debug("\u4f9b\u5e94\u5546\u521b\u5efa\u63a5\u53e3\u8c03\u7528\u6210\u529f\uff0c\u8bf7\u6c42\u53c2\u6570: [{}], \u54cd\u5e94\u5185\u5bb9: [{}]", (Object)requestBizData, (Object)jackyunResponse);
        if (jackyunResponse.isSuccess()) {
            JSONObject response = JsonUtils.deJson(jackyunResponse.toJson(), JSONObject.class);
            responseBizData = (ErpVendCreateV2ResponseBizData)response.getJSONObject("result").getJSONObject("data").toJavaObject(ErpVendCreateV2ResponseBizData.class);
        }
        return jackyunResponse;
    }

    public JackyunResponse getJackyunResponse(String method, BaseRequestBizData requestBizData, String pushRecordInterType, Long docId, String docNo) {
        JackyunResponse jackyunResponse = this.clientService.callApi(method, requestBizData, pushRecordInterType, docId, docNo);
        System.out.println(jackyunResponse.toJson());
        return jackyunResponse;
    }

    public void erpStorageGoodsDocInV2() {
        ErpStorageGoodsDocInV2RequestBizData requestBizData = new ErpStorageGoodsDocInV2RequestBizData();
        requestBizData.setPageSize(10);
        requestBizData.setSelelctFields("recId,goodsdocNo");
        requestBizData.setGoodsDocNo("CRK202405070001");
        JackyunResponse jackyunResponse = this.getJackyunResponse(ApiEnum.ERPSTORAGEGOODSDOCINV2.getValue(), requestBizData, "", 0L, "");
        List responseBizData = null;
        if (jackyunResponse.isSuccess()) {
            JSONObject response = JsonUtils.deJson(jackyunResponse.toJson(), JSONObject.class);
            responseBizData = response.getJSONObject("result").getJSONArray("data").toJavaList(ErpStorageGoodsDocInV2ResponseBizData.class);
        }
        System.out.println(JsonUtils.toJson(responseBizData));
    }

    public void erpStorageGoodsDocOutV2() {
        ErpStorageGoodsDocOutV2RequestBizData requestBizData = new ErpStorageGoodsDocOutV2RequestBizData();
        requestBizData.setPageSize(10);
        requestBizData.setSelelctFields("recId,goodsdocNo");
        JackyunResponse jackyunResponse = this.getJackyunResponse(ApiEnum.ERPSTORAGEGOODSDOCOUTV2.getValue(), requestBizData, "", 0L, "");
        List responseBizData = null;
        if (jackyunResponse.isSuccess()) {
            JSONObject response = JsonUtils.deJson(jackyunResponse.toJson(), JSONObject.class);
            responseBizData = response.getJSONObject("result").getJSONArray("data").toJavaList(ErpStorageGoodsDocOutV2ResponseBizData.class);
        }
        System.out.println(JsonUtils.toJson(responseBizData));
    }

    public JackyunResponse erpStockCreateAndStockIn(ErpStockCreateAndStockInRequestBizData requestBizData, String pushRecordInterType, Long docId, String docNo) {
        requestBizData.setPageSize(10);
        JackyunResponse jackyunResponse = this.getJackyunResponse(ApiEnum.ERPSTORAGESTOCKINCREATE.getValue(), requestBizData, pushRecordInterType, docId, docNo);
        List responseBizData = null;
        if (jackyunResponse.isSuccess()) {
            JSONObject response = JsonUtils.deJson(jackyunResponse.toJson(), JSONObject.class);
            responseBizData = response.getJSONObject("result").getJSONArray("data").toJavaList(ErpStockCreateAndStockInResponseBizData.class);
        }
        return jackyunResponse;
    }

    public JackyunServiceImpl(JackyunOpenClientService clientService, OutsidePushRecordRepository outsidePushRecordRepository) {
        this.clientService = clientService;
        this.outsidePushRecordRepository = outsidePushRecordRepository;
    }
}

