package com.elitesland.zhiyuan.openapi.outer.jackyun.data.bizdata.erp.erpstockcreateandstockin;

import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

/**
 * @description: stockInDetailViews实体类
 * luoxin
 */
@Data
public class StockInDetailViews{
	/**
	 * 匹配货品信息的外部货品编号(按skuId>outSkuCode>skuBarcode匹配顺序，必传一个) 
	 */ 
	private String outSkuCode;
	/**
	 * 条码(按skuId>outSkuCode>skuBarcode匹配顺序，必传一个) 
	 */ 
	private String skuBarcode;
	/**
	 * 关联实际业务明细表的id 
	 */ 
	private String relDetailId;
	/**
	 * 计量单位 
	 */ 
	private String unitName;
	/**
	 * 入库数量 
	 */ 
	private BigDecimal skuCount;
	/**
	 * 入库价格 
	 */ 
	private BigDecimal skuPrice;
	/**
	 * 入库金额 
	 */ 
	private BigDecimal totalAmount;
	/**
	 * 是否正品，1是0否 
	 */ 
	private Byte isCertified;
	/**
	 * 批号明细，批号货品必传 
	 */ 
	private List<BatchList> batchList;

	/**
	 * 序列号明细，序列号货品必传 
	 */ 
	private List<SerialList> serialList;

	/**
	 * 备注 
	 */ 
	private String rowRemark;
	/**
	 * 规格id(按skuId>outSkuCode>skuBarcode匹配顺序，必传一个) 
	 */ 
	private Long skuId;


}

