package com.elitesland.zhiyuan.openapi.outer.jackyun.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.elitescloud.cloudt.sys.outlog.OutsidePushInter;
import com.elitesland.zhiyuan.openapi.outer.jackyun.data.JackyunResponse;
import com.elitesland.zhiyuan.openapi.outer.jackyun.data.bizdata.core.BaseRequestBizData;
import com.elitesland.zhiyuan.openapi.outer.jackyun.data.bizdata.erp.erpgoodskuimportbatch.ErpGoodsSkuimPortBatchRequestBizData;
import com.elitesland.zhiyuan.openapi.outer.jackyun.data.bizdata.erp.erpgoodskuimportbatch.ErpGoodsSkuimPortBatchResponseBizData;
import com.elitesland.zhiyuan.openapi.outer.jackyun.data.bizdata.erp.erpstockcreateandstockin.ErpStockCreateAndStockInRequestBizData;
import com.elitesland.zhiyuan.openapi.outer.jackyun.data.bizdata.erp.erpstockcreateandstockin.ErpStockCreateAndStockInResponseBizData;
import com.elitesland.zhiyuan.openapi.outer.jackyun.data.bizdata.erp.erpstockcreateandstockout.ErpStockCreateAndStockOutRequestBizData;
import com.elitesland.zhiyuan.openapi.outer.jackyun.data.bizdata.erp.erpstockcreateandstockout.ErpStockCreateAndStockOutResponseBizData;
import com.elitesland.zhiyuan.openapi.outer.jackyun.data.bizdata.erp.erpstockinget.ErpStockInGetRequestBizData;
import com.elitesland.zhiyuan.openapi.outer.jackyun.data.bizdata.erp.erpstockinget.ErpStockInGetResponseBizData;
import com.elitesland.zhiyuan.openapi.outer.jackyun.data.bizdata.erp.erpstoragegoodsdocoutv2.ErpStorageGoodsDocOutV2RequestBizData;
import com.elitesland.zhiyuan.openapi.outer.jackyun.data.bizdata.erp.erpstoragegoodsdocoutv2.ErpStorageGoodsDocOutV2ResponseBizData;
import com.elitesland.zhiyuan.openapi.outer.jackyun.data.bizdata.erp.erpvendcreatev2.ErpVendCreateV2RequestBizData;
import com.elitesland.zhiyuan.openapi.outer.jackyun.data.bizdata.erp.erpvendcreatev2.ErpVendCreateV2ResponseBizData;
import com.elitesland.zhiyuan.openapi.outer.jackyun.data.bizdata.erp.omstradefullinfoget.core.OrderTradeFullInfoGetRequestBizData;
import com.elitesland.zhiyuan.openapi.outer.jackyun.data.bizdata.erp.omstradefullinfoget.core.OrderTradeFullInfoResponseBizData;
import com.elitesland.zhiyuan.openapi.outer.jackyun.data.core.ApiEnum;
import com.elitesland.zhiyuan.openapi.outer.jackyun.params.MaterialCreateRequest;
import com.elitesland.zhiyuan.openapi.outer.jackyun.params.VendCreateRequest;
import com.elitesland.zhiyuan.openapi.outer.jackyun.service.JackyunOpenClientService;
import com.elitesland.zhiyuan.openapi.outer.jackyun.service.JackyunService;
import com.elitesland.zhiyuan.openapi.outer.jackyun.util.JsonUtils;
import com.elitesland.zhiyuan.openapi.outer.jushuitan.params.req.PurchaseInboundQueryRequest;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Slf4j
@Service
@RequiredArgsConstructor
// 配置文件动态刷新
@RefreshScope
public class JackyunServiceImpl implements JackyunService {

    /**
     * 请求吉客云开放平台服务
     */
    private final JackyunOpenClientService clientService;


    /**
     * 物料创建请求接口
     *
     * @param materialCreateRequest
     * @return
     */
    @Override
    public JackyunResponse createMaterial(MaterialCreateRequest materialCreateRequest, String pushRecordInterType, Long docId, String docNo) {
        // 记录请求开始
        log.info("开始创建物料，请求参数: [goodsNo={}] [goodsName={}]",
                materialCreateRequest.getGoodsNo(), materialCreateRequest.getGoodsName());
        // 业务校验
        if (StringUtils.isBlank(materialCreateRequest.getGoodsNo())) {
            throw new IllegalArgumentException("货品编码 goodsNo 不能为空");
        }
        if (StringUtils.isBlank(materialCreateRequest.getGoodsName())) {
            throw new IllegalArgumentException("货品名称 goodsName 不能为空");
        }

        List<BaseRequestBizData> erpGoodsSkuimPortBatchRequestBizDataList = new ArrayList<>();
        ErpGoodsSkuimPortBatchRequestBizData requestBizData1 = new ErpGoodsSkuimPortBatchRequestBizData();
        requestBizData1.setGoodsName(materialCreateRequest.getGoodsName());
        requestBizData1.setGoodsNo(materialCreateRequest.getGoodsNo());
        requestBizData1.setOutSkuCode(materialCreateRequest.getGoodsNo());
        requestBizData1.setUnitName(materialCreateRequest.getUnitName());
        requestBizData1.setDescript(materialCreateRequest.getDescript());
        requestBizData1.setSkuName(materialCreateRequest.getSkuName());
        erpGoodsSkuimPortBatchRequestBizDataList.add(requestBizData1);
        // 开放平台应用信息
        JackyunResponse jackyunResponse = clientService.callBatchApi(ApiEnum.ERPGOODSSKUIMPORTBATCH.getValue(), erpGoodsSkuimPortBatchRequestBizDataList, pushRecordInterType, docId, docNo);
        List<ErpGoodsSkuimPortBatchResponseBizData> responseBizData = null;
        log.debug("物料创建接口调用成功，请求参数: [{}], 响应内容: [{}]",
                erpGoodsSkuimPortBatchRequestBizDataList, jackyunResponse);
        if (jackyunResponse.isSuccess()) {
            JSONObject response = JsonUtils.deJson(jackyunResponse.toJson(), JSONObject.class);
            responseBizData = response.getJSONObject("result").getJSONArray("data").toJavaList(ErpGoodsSkuimPortBatchResponseBizData.class);
        }
        return jackyunResponse;
    }


    /**
     * 供应商更新创建
     */
    @Override
    public JackyunResponse createVendor(VendCreateRequest request, String pushRecordInterType, Long docId, String docNo) {

        // 记录请求开始
        log.info("开始创建供应商，请求参数: [code={}] [name={}]",
                request.getCode(), request.getName());

        ErpVendCreateV2RequestBizData requestBizData = new ErpVendCreateV2RequestBizData();
        requestBizData.setLeader("测试工作人");
        requestBizData.setCode(request.getCode());
        requestBizData.setClassCode(request.getCode());
        requestBizData.setName(request.getName());
        requestBizData.setClassName(request.getClassName());

        JackyunResponse jackyunResponse = getJackyunResponse(ApiEnum.ERPVENDCREATEV2.getValue(), requestBizData, pushRecordInterType, docId, docNo);
        ErpVendCreateV2ResponseBizData responseBizData = null;

        log.debug("供应商创建接口调用成功，请求参数: [{}], 响应内容: [{}]", requestBizData, jackyunResponse);

        if (jackyunResponse.isSuccess()) {
            JSONObject response = JsonUtils.deJson(jackyunResponse.toJson(), JSONObject.class);
            responseBizData = response.getJSONObject("result").getJSONObject("data").toJavaObject(ErpVendCreateV2ResponseBizData.class);
        }
        return jackyunResponse;
    }

    /**
     * 发送接口请求并获取数据
     *
     * @param method         Api方法名
     * @param requestBizData 请求参数
     * @return 请求的返回数据
     */
    public JackyunResponse getJackyunResponse(String method, BaseRequestBizData requestBizData, String pushRecordInterType, Long docId, String docNo) {

        JackyunResponse jackyunResponse = this.clientService.callApi(method, requestBizData, pushRecordInterType, docId, docNo);
        System.out.println(jackyunResponse.toJson());
        return jackyunResponse;
    }


    /**
     * 销售订单
     */
    public JackyunResponse testTradeFullInfoGet() {
        Byte total = 0;
        OrderTradeFullInfoGetRequestBizData requestBizData1 = new OrderTradeFullInfoGetRequestBizData();
        requestBizData1.setStartConsignTime(LocalDateTime.of(2019, 6, 5, 12, 00, 00));
        requestBizData1.setEndConsignTime(LocalDateTime.of(2019, 9, 5, 12, 00, 00));
        requestBizData1.setHasTotal(total);
        requestBizData1.setTradeStatus(6000);//状态默认发货在途
        requestBizData1.setTradeTypeList(List.of(2, 5, 7, 8, 12, 15)); //销售订单类型
        requestBizData1.setPageSize(200);//默认查200行
        requestBizData1.setPageIndex(0);

        JackyunResponse jackyunResponse = getJackyunResponse(ApiEnum.OMSTRADEFULLINFOGET.getValue(), requestBizData1,OutsidePushInter.INV_ORDER_SYNC_TO_JKY.name() , 0L, "");
        System.out.println("开放平台查询返回->" + JsonUtils.toJson(jackyunResponse));
        OrderTradeFullInfoResponseBizData orderTradeFullInfoResponseBizData = null;
        if (jackyunResponse.isSuccess()) {
            JSONObject response = JsonUtils.deJson(jackyunResponse.toJson(), JSONObject.class);
            // 销售单查询响应实体类
            orderTradeFullInfoResponseBizData = JsonUtils.deJson(JsonUtils.toJson(response.getJSONObject("result").getJSONObject("data")),
                    OrderTradeFullInfoResponseBizData.class);
        }
        return jackyunResponse;
    }

    /**
     * 创建入库申请单并入库
     */
    @Override
    public JackyunResponse erpStockCreateAndStockIn(ErpStockCreateAndStockInRequestBizData requestBizData, Long docId, String docNo) {
        //requestBizData.setPageSize(10);
        // 1. 参数验证
        if (requestBizData == null || CollectionUtils.isEmpty(requestBizData.getStockInDetailViews())) {
            String errorMsg = "erpStockCreateAndStockIn请求参数为空或list列表为空";
            log.error("参数校验失败: {}", errorMsg);
            throw new IllegalArgumentException(errorMsg);
        }
        log.info("吉客云采购入库批量创建接口 - 请求开始 | 入库单明细数量: {}", requestBizData.getStockInDetailViews().size());
        log.debug("吉客云采购入库批量创建接口 - 请求数据: {}", requestBizData);
        JackyunResponse jackyunResponse = getJackyunResponse(ApiEnum.ERPSTORAGESTOCKINCREATE.getValue(), requestBizData, OutsidePushInter.INV_IDO_CREATE_SYNC_TO_JKY.name(), docId, docNo);
        log.debug("吉客云采购入库批量创建接口 - 响应: {}", jackyunResponse);
        return jackyunResponse;
    }


    /**
     * 分页查询入库申请单
     */
    @Override
    public JackyunResponse erpStockInGet(ErpStockInGetRequestBizData requestBizData, Long docId, String docNo) {
        requestBizData.setPageSize(10);
        requestBizData.setInNo("RK202404180022");
        JackyunResponse jackyunResponse = getJackyunResponse(ApiEnum.ERPSTOCKINGETDETAIL.getValue(), requestBizData,OutsidePushInter.INV_IDO_SYNC_TO_JKY.name() , docId, docNo);
        List<ErpStockInGetResponseBizData> responseBizData = new ArrayList<>();

        if (jackyunResponse.isSuccess()) {
            JSONObject response = JsonUtils.deJson(jackyunResponse.toJson(), JSONObject.class);
            responseBizData = response.getJSONObject("result").getJSONArray("data").toJavaList(ErpStockInGetResponseBizData.class);
        }
        return jackyunResponse;
    }

    /**
     * 创建出库申请单并出库
     */
    @Override
    public JackyunResponse erpStockCreateAndStockOut(ErpStockCreateAndStockOutRequestBizData requestBizData,Long docId, String docNo) {
        requestBizData.setPageSize(10);
        JackyunResponse jackyunResponse = getJackyunResponse(ApiEnum.ERPSTORAGESTOCKOUTCREATE.getValue(), requestBizData,OutsidePushInter.INV_ODO_CREATE_SYNC_TO_JKY.name(),docId,docNo);
        List<ErpStockCreateAndStockOutResponseBizData> responseBizData = null;
        if (jackyunResponse.isSuccess()) {
            JSONObject response = JsonUtils.deJson(jackyunResponse.toJson(), JSONObject.class);
            responseBizData = response.getJSONObject("result").getJSONArray("data").toJavaList(ErpStockCreateAndStockOutResponseBizData.class);
        }
        return jackyunResponse;
    }


    /**
     * 分页查询出库单
     */
    @Override
    public JackyunResponse erpStorageGoodsDocOutV2(ErpStorageGoodsDocOutV2RequestBizData requestBizData, Long docId, String docNo) {

        requestBizData.setPageSize(10);
        requestBizData.setSelelctFields("recId,goodsdocNo");
        JackyunResponse jackyunResponse = getJackyunResponse(ApiEnum.ERPSTORAGEGOODSDOCOUTV2.getValue(), requestBizData,OutsidePushInter.INV_ODO_SYNC_TO_JKY.name(),docId,docNo);
        List<ErpStorageGoodsDocOutV2ResponseBizData> responseBizData = null;

        if (jackyunResponse.isSuccess()) {
            JSONObject response = JsonUtils.deJson(jackyunResponse.toJson(), JSONObject.class);
            responseBizData = response.getJSONObject("result").getJSONArray("data").toJavaList(ErpStorageGoodsDocOutV2ResponseBizData.class);
        }
        return jackyunResponse;
    }


    /**
     * 创建出库申请单报废并出库
     */
    public JackyunResponse erpStockCreateAndStockFailOut(ErpStockCreateAndStockOutRequestBizData requestBizData, String pushRecordInterType, Long docId, String docNo) {
        requestBizData.setPageSize(10);
        JackyunResponse jackyunResponse = getJackyunResponse(ApiEnum.ERPSTORAGESTOCKOUTCREATE.getValue(), requestBizData,pushRecordInterType,docId,docNo);
        List<ErpStockCreateAndStockOutResponseBizData> responseBizData = null;
        if (jackyunResponse.isSuccess()) {
            JSONObject response = JsonUtils.deJson(jackyunResponse.toJson(), JSONObject.class);
            responseBizData = response.getJSONObject("result").getJSONArray("data").toJavaList(ErpStockCreateAndStockOutResponseBizData.class);
        }
        return jackyunResponse;
    }


    /**
     * 分页查询报废出库单
     */

    public JackyunResponse erpStorageGoodsDocFailOutV2(ErpStorageGoodsDocOutV2RequestBizData requestBizData, String pushRecordInterType, Long docId, String docNo) {

        requestBizData.setPageSize(10);
        requestBizData.setSelelctFields("recId,goodsdocNo");
        JackyunResponse jackyunResponse = getJackyunResponse(ApiEnum.ERPSTORAGEGOODSDOCOUTV2.getValue(), requestBizData,pushRecordInterType,docId,docNo);
        List<ErpStorageGoodsDocOutV2ResponseBizData> responseBizData = null;

        if (jackyunResponse.isSuccess()) {
            JSONObject response = JsonUtils.deJson(jackyunResponse.toJson(), JSONObject.class);
            responseBizData = response.getJSONObject("result").getJSONArray("data").toJavaList(ErpStorageGoodsDocOutV2ResponseBizData.class);
        }
      return jackyunResponse;
    }


    /**
     * 构建采购出库查询请求参数
     */
    private Map<String, Object> buildPurchaseOnboundQueryParams(PurchaseInboundQueryRequest request) {
        Map<String, Object> requestMap = new HashMap<>();

        if (request.getPage_index() != null) {
            requestMap.put("page_index", request.getPage_index());
        }
        if (request.getPage_size() != null) {
            requestMap.put("page_size", request.getPage_size());
        }
        if (org.springframework.util.StringUtils.hasText(request.getModified_begin())) {
            requestMap.put("modified_begin", request.getModified_begin());
        }
        if (org.springframework.util.StringUtils.hasText(request.getModified_end())) {
            requestMap.put("modified_end", request.getModified_end());
        }
        if (!CollectionUtils.isEmpty(request.getPo_ids())) {
            requestMap.put("po_ids", request.getPo_ids());
        }
        if (!CollectionUtils.isEmpty(request.getIo_ids())) {
            requestMap.put("io_ids", request.getIo_ids());
        }
        if (!CollectionUtils.isEmpty(request.getStatuss())) {
            requestMap.put("statuss", request.getStatuss());
        }
        if (!CollectionUtils.isEmpty(request.getSo_ids())) {
            requestMap.put("so_ids", request.getSo_ids());
        }
        if (request.getStart_ts() != null) {
            requestMap.put("start_ts", request.getStart_ts());
        }
        if (request.getIs_get_total() != null) {
            requestMap.put("is_get_total", request.getIs_get_total());
        }
        if (request.getDate_type() != null) {
            requestMap.put("date_type", request.getDate_type());
        }
        if (!CollectionUtils.isEmpty(request.getSeller_ids())) {
            requestMap.put("seller_ids", request.getSeller_ids());
        }
        if (request.getOwner_co_id() != null) {
            requestMap.put("owner_co_id", request.getOwner_co_id());
        }

        return requestMap;
    }
}