/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.zhiyuan.openapi.outer.jackyun.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.elitescloud.cloudt.sys.outlog.OutsidePushInter;
import com.elitesland.zhiyuan.openapi.outer.jackyun.data.JackyunResponse;
import com.elitesland.zhiyuan.openapi.outer.jackyun.data.bizdata.core.BaseRequestBizData;
import com.elitesland.zhiyuan.openapi.outer.jackyun.data.bizdata.erp.erpgoodskuimportbatch.ErpGoodsSkuimPortBatchRequestBizData;
import com.elitesland.zhiyuan.openapi.outer.jackyun.data.bizdata.erp.erpgoodskuimportbatch.ErpGoodsSkuimPortBatchResponseBizData;
import com.elitesland.zhiyuan.openapi.outer.jackyun.data.bizdata.erp.erpstockcreateandstockin.ErpStockCreateAndStockInRequestBizData;
import com.elitesland.zhiyuan.openapi.outer.jackyun.data.bizdata.erp.erpstockcreateandstockout.ErpStockCreateAndStockOutRequestBizData;
import com.elitesland.zhiyuan.openapi.outer.jackyun.data.bizdata.erp.erpstockcreateandstockout.ErpStockCreateAndStockOutResponseBizData;
import com.elitesland.zhiyuan.openapi.outer.jackyun.data.bizdata.erp.erpstockinget.ErpStockInGetRequestBizData;
import com.elitesland.zhiyuan.openapi.outer.jackyun.data.bizdata.erp.erpstockinget.ErpStockInGetResponseBizData;
import com.elitesland.zhiyuan.openapi.outer.jackyun.data.bizdata.erp.erpstoragegoodsdocoutv2.ErpStorageGoodsDocOutV2RequestBizData;
import com.elitesland.zhiyuan.openapi.outer.jackyun.data.bizdata.erp.erpstoragegoodsdocoutv2.ErpStorageGoodsDocOutV2ResponseBizData;
import com.elitesland.zhiyuan.openapi.outer.jackyun.data.bizdata.erp.erpvendcreatev2.ErpVendCreateV2RequestBizData;
import com.elitesland.zhiyuan.openapi.outer.jackyun.data.bizdata.erp.erpvendcreatev2.ErpVendCreateV2ResponseBizData;
import com.elitesland.zhiyuan.openapi.outer.jackyun.data.bizdata.erp.omstradefullinfoget.core.OrderTradeFullInfoGetRequestBizData;
import com.elitesland.zhiyuan.openapi.outer.jackyun.data.bizdata.erp.omstradefullinfoget.core.OrderTradeFullInfoResponseBizData;
import com.elitesland.zhiyuan.openapi.outer.jackyun.data.core.ApiEnum;
import com.elitesland.zhiyuan.openapi.outer.jackyun.params.MaterialCreateRequest;
import com.elitesland.zhiyuan.openapi.outer.jackyun.params.VendCreateRequest;
import com.elitesland.zhiyuan.openapi.outer.jackyun.service.JackyunOpenClientService;
import com.elitesland.zhiyuan.openapi.outer.jackyun.service.JackyunService;
import com.elitesland.zhiyuan.openapi.outer.jackyun.util.JsonUtils;
import com.elitesland.zhiyuan.openapi.outer.jushuitan.params.req.PurchaseInboundQueryRequest;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
@RefreshScope
public class JackyunServiceImpl
implements JackyunService {
    private static final Logger log = LoggerFactory.getLogger(JackyunServiceImpl.class);
    private final JackyunOpenClientService clientService;

    @Override
    public JackyunResponse createMaterial(MaterialCreateRequest materialCreateRequest, String pushRecordInterType, Long docId, String docNo) {
        log.info("\u5f00\u59cb\u521b\u5efa\u7269\u6599\uff0c\u8bf7\u6c42\u53c2\u6570: [goodsNo={}] [goodsName={}]", (Object)materialCreateRequest.getGoodsNo(), (Object)materialCreateRequest.getGoodsName());
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)materialCreateRequest.getGoodsNo())) {
            throw new IllegalArgumentException("\u8d27\u54c1\u7f16\u7801 goodsNo \u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)materialCreateRequest.getGoodsName())) {
            throw new IllegalArgumentException("\u8d27\u54c1\u540d\u79f0 goodsName \u4e0d\u80fd\u4e3a\u7a7a");
        }
        ArrayList<BaseRequestBizData> erpGoodsSkuimPortBatchRequestBizDataList = new ArrayList<BaseRequestBizData>();
        ErpGoodsSkuimPortBatchRequestBizData requestBizData1 = new ErpGoodsSkuimPortBatchRequestBizData();
        requestBizData1.setGoodsName(materialCreateRequest.getGoodsName());
        requestBizData1.setGoodsNo(materialCreateRequest.getGoodsNo());
        requestBizData1.setOutSkuCode(materialCreateRequest.getGoodsNo());
        requestBizData1.setUnitName(materialCreateRequest.getUnitName());
        requestBizData1.setDescript(materialCreateRequest.getDescript());
        requestBizData1.setSkuName(materialCreateRequest.getSkuName());
        erpGoodsSkuimPortBatchRequestBizDataList.add(requestBizData1);
        JackyunResponse jackyunResponse = this.clientService.callBatchApi(ApiEnum.ERPGOODSSKUIMPORTBATCH.getValue(), erpGoodsSkuimPortBatchRequestBizDataList, pushRecordInterType, docId, docNo);
        List responseBizData = null;
        log.debug("\u7269\u6599\u521b\u5efa\u63a5\u53e3\u8c03\u7528\u6210\u529f\uff0c\u8bf7\u6c42\u53c2\u6570: [{}], \u54cd\u5e94\u5185\u5bb9: [{}]", erpGoodsSkuimPortBatchRequestBizDataList, (Object)jackyunResponse);
        if (jackyunResponse.isSuccess()) {
            JSONObject response = JsonUtils.deJson(jackyunResponse.toJson(), JSONObject.class);
            responseBizData = response.getJSONObject("result").getJSONArray("data").toJavaList(ErpGoodsSkuimPortBatchResponseBizData.class);
        }
        return jackyunResponse;
    }

    @Override
    public JackyunResponse createVendor(VendCreateRequest request, String pushRecordInterType, Long docId, String docNo) {
        log.info("\u5f00\u59cb\u521b\u5efa\u4f9b\u5e94\u5546\uff0c\u8bf7\u6c42\u53c2\u6570: [code={}] [name={}]", (Object)request.getCode(), (Object)request.getName());
        ErpVendCreateV2RequestBizData requestBizData = new ErpVendCreateV2RequestBizData();
        requestBizData.setLeader("\u6d4b\u8bd5\u5de5\u4f5c\u4eba");
        requestBizData.setCode(request.getCode());
        requestBizData.setClassCode(request.getCode());
        requestBizData.setName(request.getName());
        requestBizData.setClassName(request.getClassName());
        JackyunResponse jackyunResponse = this.getJackyunResponse(ApiEnum.ERPVENDCREATEV2.getValue(), requestBizData, pushRecordInterType, docId, docNo);
        ErpVendCreateV2ResponseBizData responseBizData = null;
        log.debug("\u4f9b\u5e94\u5546\u521b\u5efa\u63a5\u53e3\u8c03\u7528\u6210\u529f\uff0c\u8bf7\u6c42\u53c2\u6570: [{}], \u54cd\u5e94\u5185\u5bb9: [{}]", (Object)requestBizData, (Object)jackyunResponse);
        if (jackyunResponse.isSuccess()) {
            JSONObject response = JsonUtils.deJson(jackyunResponse.toJson(), JSONObject.class);
            responseBizData = (ErpVendCreateV2ResponseBizData)response.getJSONObject("result").getJSONObject("data").toJavaObject(ErpVendCreateV2ResponseBizData.class);
        }
        return jackyunResponse;
    }

    public JackyunResponse getJackyunResponse(String method, BaseRequestBizData requestBizData, String pushRecordInterType, Long docId, String docNo) {
        JackyunResponse jackyunResponse = this.clientService.callApi(method, requestBizData, pushRecordInterType, docId, docNo);
        System.out.println(jackyunResponse.toJson());
        return jackyunResponse;
    }

    public JackyunResponse testTradeFullInfoGet() {
        Byte total = 0;
        OrderTradeFullInfoGetRequestBizData requestBizData1 = new OrderTradeFullInfoGetRequestBizData();
        requestBizData1.setStartConsignTime(LocalDateTime.of(2019, 6, 5, 12, 0, 0));
        requestBizData1.setEndConsignTime(LocalDateTime.of(2019, 9, 5, 12, 0, 0));
        requestBizData1.setHasTotal(total);
        requestBizData1.setTradeStatus(6000);
        requestBizData1.setTradeTypeList(List.of(Integer.valueOf(2), Integer.valueOf(5), Integer.valueOf(7), Integer.valueOf(8), Integer.valueOf(12), Integer.valueOf(15)));
        requestBizData1.setPageSize(200);
        requestBizData1.setPageIndex(0);
        JackyunResponse jackyunResponse = this.getJackyunResponse(ApiEnum.OMSTRADEFULLINFOGET.getValue(), requestBizData1, OutsidePushInter.INV_ORDER_SYNC_TO_JKY.name(), 0L, "");
        System.out.println("\u5f00\u653e\u5e73\u53f0\u67e5\u8be2\u8fd4\u56de->" + JsonUtils.toJson(jackyunResponse));
        OrderTradeFullInfoResponseBizData orderTradeFullInfoResponseBizData = null;
        if (jackyunResponse.isSuccess()) {
            JSONObject response = JsonUtils.deJson(jackyunResponse.toJson(), JSONObject.class);
            orderTradeFullInfoResponseBizData = JsonUtils.deJson(JsonUtils.toJson(response.getJSONObject("result").getJSONObject("data")), OrderTradeFullInfoResponseBizData.class);
        }
        return jackyunResponse;
    }

    @Override
    public JackyunResponse erpStockCreateAndStockIn(ErpStockCreateAndStockInRequestBizData requestBizData, Long docId, String docNo) {
        if (requestBizData == null || CollectionUtils.isEmpty(requestBizData.getStockInDetailViews())) {
            String errorMsg = "erpStockCreateAndStockIn\u8bf7\u6c42\u53c2\u6570\u4e3a\u7a7a\u6216list\u5217\u8868\u4e3a\u7a7a";
            log.error("\u53c2\u6570\u6821\u9a8c\u5931\u8d25: {}", (Object)errorMsg);
            throw new IllegalArgumentException(errorMsg);
        }
        log.info("\u5409\u5ba2\u4e91\u91c7\u8d2d\u5165\u5e93\u6279\u91cf\u521b\u5efa\u63a5\u53e3 - \u8bf7\u6c42\u5f00\u59cb | \u5165\u5e93\u5355\u660e\u7ec6\u6570\u91cf: {}", (Object)requestBizData.getStockInDetailViews().size());
        log.debug("\u5409\u5ba2\u4e91\u91c7\u8d2d\u5165\u5e93\u6279\u91cf\u521b\u5efa\u63a5\u53e3 - \u8bf7\u6c42\u6570\u636e: {}", (Object)requestBizData);
        JackyunResponse jackyunResponse = this.getJackyunResponse(ApiEnum.ERPSTORAGESTOCKINCREATE.getValue(), requestBizData, OutsidePushInter.INV_IDO_CREATE_SYNC_TO_JKY.name(), docId, docNo);
        log.debug("\u5409\u5ba2\u4e91\u91c7\u8d2d\u5165\u5e93\u6279\u91cf\u521b\u5efa\u63a5\u53e3 - \u54cd\u5e94: {}", (Object)jackyunResponse);
        return jackyunResponse;
    }

    @Override
    public JackyunResponse erpStockInGet(ErpStockInGetRequestBizData requestBizData, Long docId, String docNo) {
        requestBizData.setPageSize(10);
        requestBizData.setInNo("RK202404180022");
        JackyunResponse jackyunResponse = this.getJackyunResponse(ApiEnum.ERPSTOCKINGETDETAIL.getValue(), requestBizData, OutsidePushInter.INV_IDO_SYNC_TO_JKY.name(), docId, docNo);
        List responseBizData = new ArrayList();
        if (jackyunResponse.isSuccess()) {
            JSONObject response = JsonUtils.deJson(jackyunResponse.toJson(), JSONObject.class);
            responseBizData = response.getJSONObject("result").getJSONArray("data").toJavaList(ErpStockInGetResponseBizData.class);
        }
        return jackyunResponse;
    }

    @Override
    public JackyunResponse erpStockCreateAndStockOut(ErpStockCreateAndStockOutRequestBizData requestBizData, Long docId, String docNo) {
        requestBizData.setPageSize(10);
        JackyunResponse jackyunResponse = this.getJackyunResponse(ApiEnum.ERPSTORAGESTOCKOUTCREATE.getValue(), requestBizData, OutsidePushInter.INV_ODO_CREATE_SYNC_TO_JKY.name(), docId, docNo);
        List responseBizData = null;
        if (jackyunResponse.isSuccess()) {
            JSONObject response = JsonUtils.deJson(jackyunResponse.toJson(), JSONObject.class);
            responseBizData = response.getJSONObject("result").getJSONArray("data").toJavaList(ErpStockCreateAndStockOutResponseBizData.class);
        }
        return jackyunResponse;
    }

    @Override
    public JackyunResponse erpStorageGoodsDocOutV2(ErpStorageGoodsDocOutV2RequestBizData requestBizData, Long docId, String docNo) {
        requestBizData.setPageSize(10);
        requestBizData.setSelelctFields("recId,goodsdocNo");
        JackyunResponse jackyunResponse = this.getJackyunResponse(ApiEnum.ERPSTORAGEGOODSDOCOUTV2.getValue(), requestBizData, OutsidePushInter.INV_ODO_SYNC_TO_JKY.name(), docId, docNo);
        List responseBizData = null;
        if (jackyunResponse.isSuccess()) {
            JSONObject response = JsonUtils.deJson(jackyunResponse.toJson(), JSONObject.class);
            responseBizData = response.getJSONObject("result").getJSONArray("data").toJavaList(ErpStorageGoodsDocOutV2ResponseBizData.class);
        }
        return jackyunResponse;
    }

    public JackyunResponse erpStockCreateAndStockFailOut(ErpStockCreateAndStockOutRequestBizData requestBizData, String pushRecordInterType, Long docId, String docNo) {
        requestBizData.setPageSize(10);
        JackyunResponse jackyunResponse = this.getJackyunResponse(ApiEnum.ERPSTORAGESTOCKOUTCREATE.getValue(), requestBizData, pushRecordInterType, docId, docNo);
        List responseBizData = null;
        if (jackyunResponse.isSuccess()) {
            JSONObject response = JsonUtils.deJson(jackyunResponse.toJson(), JSONObject.class);
            responseBizData = response.getJSONObject("result").getJSONArray("data").toJavaList(ErpStockCreateAndStockOutResponseBizData.class);
        }
        return jackyunResponse;
    }

    public JackyunResponse erpStorageGoodsDocFailOutV2(ErpStorageGoodsDocOutV2RequestBizData requestBizData, String pushRecordInterType, Long docId, String docNo) {
        requestBizData.setPageSize(10);
        requestBizData.setSelelctFields("recId,goodsdocNo");
        JackyunResponse jackyunResponse = this.getJackyunResponse(ApiEnum.ERPSTORAGEGOODSDOCOUTV2.getValue(), requestBizData, pushRecordInterType, docId, docNo);
        List responseBizData = null;
        if (jackyunResponse.isSuccess()) {
            JSONObject response = JsonUtils.deJson(jackyunResponse.toJson(), JSONObject.class);
            responseBizData = response.getJSONObject("result").getJSONArray("data").toJavaList(ErpStorageGoodsDocOutV2ResponseBizData.class);
        }
        return jackyunResponse;
    }

    private Map<String, Object> buildPurchaseOnboundQueryParams(PurchaseInboundQueryRequest request) {
        HashMap<String, Object> requestMap = new HashMap<String, Object>();
        if (request.getPage_index() != null) {
            requestMap.put("page_index", request.getPage_index());
        }
        if (request.getPage_size() != null) {
            requestMap.put("page_size", request.getPage_size());
        }
        if (StringUtils.hasText((String)request.getModified_begin())) {
            requestMap.put("modified_begin", request.getModified_begin());
        }
        if (StringUtils.hasText((String)request.getModified_end())) {
            requestMap.put("modified_end", request.getModified_end());
        }
        if (!CollectionUtils.isEmpty(request.getPo_ids())) {
            requestMap.put("po_ids", request.getPo_ids());
        }
        if (!CollectionUtils.isEmpty(request.getIo_ids())) {
            requestMap.put("io_ids", request.getIo_ids());
        }
        if (!CollectionUtils.isEmpty(request.getStatuss())) {
            requestMap.put("statuss", request.getStatuss());
        }
        if (!CollectionUtils.isEmpty(request.getSo_ids())) {
            requestMap.put("so_ids", request.getSo_ids());
        }
        if (request.getStart_ts() != null) {
            requestMap.put("start_ts", request.getStart_ts());
        }
        if (request.getIs_get_total() != null) {
            requestMap.put("is_get_total", request.getIs_get_total());
        }
        if (request.getDate_type() != null) {
            requestMap.put("date_type", request.getDate_type());
        }
        if (!CollectionUtils.isEmpty(request.getSeller_ids())) {
            requestMap.put("seller_ids", request.getSeller_ids());
        }
        if (request.getOwner_co_id() != null) {
            requestMap.put("owner_co_id", request.getOwner_co_id());
        }
        return requestMap;
    }

    public JackyunServiceImpl(JackyunOpenClientService clientService) {
        this.clientService = clientService;
    }
}

