package com.elitesland.zhiyuan.openapi.outer.nc.config;

import com.dtflys.forest.springboot.annotation.ForestScan;
import com.elitesland.nc.config.NcProperties;
import lombok.RequiredArgsConstructor;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

/**
 * Forest配置类
 *
 * @author duwh
 */
@Configuration
@ForestScan(basePackages = {"com.elitesland"})
@EnableConfigurationProperties(NcProperties.class)
@RequiredArgsConstructor
public class ForestConfig {

    private final NcProperties ncProperties;
    private final Environment environment;

    /**
     * 配置Forest的全局变量
     */
    @Bean
    public void configureForestVariables() {
        // 设置Forest变量，让Forest能够解析${nc.uri}
        System.setProperty("forest.variables.nc.uri", ncProperties.getUri());
        System.setProperty("forest.variables.nc.appId", ncProperties.getAppId());
        System.setProperty("forest.variables.nc.from", ncProperties.getFrom());
        System.setProperty("forest.variables.nc.userCode", ncProperties.getUserCode());
    }
}