package com.elitesland.zhiyuan.openapi.outer.jushuitan.params.resp;

import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;
import java.util.List;

/**
 * 聚水潭调拨单查询结果
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class PurchAllotResultDetailQueryResponse extends JushuitanBaseResponse {

    /**
     * 响应数据
     */
    private AllocateQueryData data;
    @Data
    public static class AllocateQueryData {
        /**
         * 调拨单数据列表
         */
        private List<IoBill> datas;
    }
    @Data
    public static class IoBill {
        private Integer wmsCoId;
        private Integer coId;
        private Integer ioId;
        private String ioDate;
        private String modified;
        private String status;
        private String warehouse;
        private String linkWarehouse;
        private String fStatus;
        private String type;
        private Integer whId;
        private Integer linkWhId;
        private Integer linkWmsCoId;
        private Integer linkIoId;
        private String soId;
        private String waveId;
        private String remark;
        private String creatorName;
        private String lockWhId;
        private String lockLinkWhId;
        private String outIoId;
        private List<String> labels;
        private List<IoBillItem> items;
        private List<Batch> batchs;
        private List<Sns> sns;
        private String receiverNameEn;
        private String receiverMobileEn;
        private String receiverState;
        private String receiverCity;
        private String receiverDistrict;
        private String receiverAddress;
        private String lId;
        private String lcId;
        private String logisticsCompany;
        private String unit;
    }
    @Data
    public static class IoBillItem {
        private Integer ioId;
        private Integer ioiId;
        private String skuId;
        private String iId;
        private Integer qty;
        private Double costPrice;
        private Double costAmount;
        private String name;
        private String propertiesValue;
        private Integer rQty;
        private String batchId;
        private String productDate;
        private Integer supplierId;
        private String expirationDate;
    }

    @Data
    public static class Sns {
        private String skuId;
        private String sn;
    }

    @Data
    public static class Batch {
        private String batchNo;
        private String skuId;
        private Integer qty;
        private String productDate;
        private Integer supplierId;
        private String supplierName;
    }
}
