package com.elitesland.zhiyuan.openapi.outer.jushuitan.params.resp;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;
import java.util.List;

/**
 * ClassName: PurchaseInboundQueryResponse
 * Description: 采购出库查询响应参数
 *
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class PurchaseOnboundQueryResponse extends JushuitanBaseResponse<PurchaseOnboundQueryResponse.PurchaseOnboundQueryData> {

    /**
     * 采购出库查询响应数据
     */
    @Data
    public static class PurchaseOnboundQueryData {

        @ApiModelProperty("采购出库数据列表")
        private List<PurchaseOnboundData> datas;

        @ApiModelProperty("第几页")
        private Integer page_index;

        @ApiModelProperty("是否有下一页")
        private Boolean has_next;

        @ApiModelProperty("总条数")
        private Integer data_count;

        @ApiModelProperty("总页数")
        private Integer page_count;

        @ApiModelProperty("每页多少条")
        private Integer page_size;
    }

    /**
     * 采购出库数据
     */
    @Data
    public static class PurchaseOnboundData {

        private Integer io_id;
        private String io_date;
        private Integer created_po_id;
        private String status;
        private String so_id;
        private String f_status;
        private String warehouse;
        private String receiver_name;
        private String receiver_mobile;
        private String receiver_state;
        private String receiver_city;
        private String receiver_district;
        private String receiver_address;
        private Integer wh_id;
        private String remark;
        private String modified;
        private Integer po_id;
        private String wms_co_id;
        private Integer seller_id;
        private String labels;
        private Integer wave_id;
        private String logistics_company;
        private Double free_amount;
        private String lc_id;
        private String l_id;
        private String archived;
        private String creator_name;
        private Integer lock_wh_id;
        private String lock_wh_name;
        private String out_io_id;
        private List<PurchaseOnboundItem> items;
        private List<BatchData> batchs;
        private List<SnData> sns;
    }

    /**
     * 商品明细信息
     */
    @Data
    public static class PurchaseOnboundItem {

        private Integer ioi_id;
        private String sku_id;
        private String name;
        private String properties_value;
        private Double tax_rate;
        private Integer qty;
        private Double cost_price;
        private Double cost_amount;
        private String i_id;
        private String remark;
        private Integer io_id;
        private Integer co_id;
        private String batch_no;
    }

    /**
     * 唯一码数据
     */
    @Data
    public static class SnData {

        private String sku_id;
        private String sn;
    }

    /**
     * 生产批次数据
     */
    @Data
    public static class BatchData {

        private String batch_no;
        private Integer qty;
        private String sku_id;
        private Integer supplier_id;
        private String supplier_name;
        private String product_date;
    }
}