package com.elitesland.zhiyuan.openapi.outer.jushuitan.params.req;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * ClassName: PurchaseInAllotQueryRequest
 * Description: 调拨查询请求参数
 *
 */
@Data
public class PurchaseInAllotQueryRequest {

    @ApiModelProperty("第几页，从1开始")
    private Integer page_index;

    @ApiModelProperty("默认30，最大不超过50")
    private Integer page_size;

    @ApiModelProperty("修改起始时间,起始时间和结束时间必须同时存在，时间间隔不能超过七天，与采购单号不能同时为空")
    private String modified_begin;

    @ApiModelProperty("修改结束时间,起始时间和结束时间必须同时存在，时间间隔不能超过七天，与采购单号不能同时为空")
    private String modified_end;


    @ApiModelProperty("入库单号与修改时间不能同时为空.采购入库单号最大不能超过30条")
    private List<Integer> io_ids;


    @ApiModelProperty("线上单号与修改时间不能同时为空")
    private List<String> so_ids;


    @ApiModelProperty("0:修改时间，modified。 2:入库时间 io_date，未传入时默认为0")
    private Integer date_type;


    @ApiModelProperty("货主编码（三方仓商家不传货主默认查自身数据，若查所有货主需传值：2147483647）")
    private Integer owner_co_id;


    @ApiModelProperty("调拨类型（调拨出，调拨入）")
    private String type;
}