package com.elitesland.zhiyuan.openapi.outer.jushuitan.params.resp;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * ClassName: PurchaseInboundResponse
 * Description: 采购入库单响应参数
 *
 * @author system
 * @date 2024/10/28
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class PurchaseInboundResponse extends JushuitanBaseResponse<List<PurchaseInboundResponse.PurchaseInboundData>> {

    /**
     * 采购入库单响应数据
     */
    @Data
    public static class PurchaseInboundData {

        @ApiModelProperty("返回信息")
        private String msg;

        @ApiModelProperty("是否执行成功")
        private Boolean is_success;

        @ApiModelProperty("外部单号")
        private String external_id;

        @ApiModelProperty("采购入库单号")
        private Integer io_id;

        @ApiModelProperty("箱号列表")
        private List<String> pack_ids;

        @ApiModelProperty("错误消息（当is_success为false时）")
        private String message;
    }
}