package com.elitesland.zhiyuan.openapi.outer.jackyun.data.bizdata.erp.erpstoragegoodsdocinv2;


import com.elitesland.zhiyuan.openapi.outer.jackyun.data.bizdata.core.BaseRequestBizData;
import lombok.Data;

/**
 * @description: 入库单查询请求参数
 * @author: luoxin
 */
@Data
public class ErpStorageGoodsDocInV2RequestBizData extends BaseRequestBizData {
	/**
	 * 分页页码 
	 */ 
	private Integer pageIndex;
	/**
	 * 分页页数 
	 */ 
	private Integer pageSize;
	/**
	 * 需要返回的字段,用“,”号拼接，子类用子类名称.属性 
	 */ 
	private String selelctFields;
	/**
	 * 入库单号 
	 */ 
	private String goodsDocNo;
	/**
	 * 创建时间的起始时间 
	 */ 
	private String startDate;
	/**
	 * 创建时间的结束时间 
	 */ 
	private String endDate;
	/**
	 * 入库类型(100-期初库存  101-采购入库  102-调拨入库 103-盘盈入库 104-其他入库 105-销售退货 106-完工入库 107-组装拆卸入库 108-翻新入库 109-报废入库 110-残次品入库111-成本调整 112-即采即入113-退料入库114-调拨退回115-维修返厂返还)
	 */ 
	private Integer inouttype;
	/**
	 * 仓库编号 
	 */ 
	private String warehouseCode;
	/**
	 * 供应商编号(往来单位) 
	 */ 
	private String vendCode;
	/**
	 * 上游单据号(关联单号) 
	 */ 
	private String billNo;
	/**
	 * 创建人名称 
	 */ 
	private String userName;
	/**
	 * 来源单号 
	 */ 
	private String sourceBillNo;
	/**
	 * 外部单号 
	 */ 
	private String outBillNo;
	/**
	 * 支持多选；，隔开(查询此采购单号关联的所有入库单) 
	 */ 
	private String purchNos;
	/**
	 * 回传状态：0未回传；1回传失败；10不回传；11已回传； 
	 */ 
	private Byte callbackStatus;
	/**
	 * 红冲状态：1蓝单（未红冲）；2被冲蓝单；9红冲单 
	 */ 
	private Byte redStatus;

	@Override
	public Integer getPageIndex() {
		return pageIndex;
	}

	@Override
	public void setPageIndex(Integer pageIndex) {
		this.pageIndex = pageIndex;
	}

	@Override
	public Integer getPageSize() {
		return pageSize;
	}

	@Override
	public void setPageSize(Integer pageSize) {
		this.pageSize = pageSize;
	}


}

