package com.elitesland.zhiyuan.openapi.outer.jackyun.data.bizdata.erp.erpstoragegoodsdocoutv2;


import com.elitesland.zhiyuan.openapi.outer.jackyun.data.bizdata.core.BaseRequestBizData;
import lombok.Data;

/**
 * @description: 分页查询出库单请求参数
 * @author: luoxin
 */
@Data
public class ErpStorageGoodsDocOutV2RequestBizData extends BaseRequestBizData {
	/**
	 * 分页页码 
	 */ 
	private Integer pageIndex;
	/**
	 * 分页页数 
	 */ 
	private Integer pageSize;
	/**
	 * 需要返回的字段,用“,”号拼接，子类用子类名称.属性 
	 */ 
	private String selelctFields;
	/**
	 * 出库单号 
	 */ 
	private String goodsDocNo;
	/**
	 * 创建时间的起始时间,当创建开始、结束时间和单号都为空，只查近一个月的数据 
	 */ 
	private String startDate;
	/**
	 * 创建时间的结束时间，当创建开始、结束时间和单号都为空，只查近一个月的数据 
	 */ 
	private String endDate;
	/**
	 * 201-销售出库 202调拨出库 203 = 盘亏出库 204-其他出库 205采购退货 206生产领料 207组装拆卸出库 208翻新出库 209报废出库 210残次品出库 211倒冲领料 212 包材出库 215维修还厂  231成本调整出库 222调拨退货出库 
	 */ 
	private Long inouttype;
	/**
	 * 来源单号 
	 */ 
	private String sourceBillNo;
	/**
	 * 仓库编号 
	 */ 
	private String warehouseCode;
	/**
	 * 供应商编号(往来单位) 
	 */ 
	private String vendCode;
	/**
	 * 上游单据号(关联单号) 
	 */ 
	private String billNo;
	/**
	 * 创建人名称 
	 */ 
	private String userName;
	/**
	 * 外部单号（全模糊匹配） 
	 */ 
	private String outBillNo;
	/**
	 * 主表更新时间起始 
	 */ 
	private String gmtModifiedStart;
	/**
	 * 主表更新时间截至 
	 */ 
	private String gmtModifiedEnd;
	/**
	 * 是否查询收发件人信息 
	 */ 
	private Integer isQuerySendAndReceive;
	/**
	 * 红冲状态：1蓝单（未红冲）；2被冲蓝单；9红冲单 
	 */ 
	private Byte redStatus;

}

