package com.elitesland.zhiyuan.openapi.outer.jackyun.data.bizdata.erp.omstradefullinfoget;

import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

@Data
public class GoodsDetail {

    /** 货品编号 */
    private String goodsNo;

    /** 货品名称 */
    private String goodsName;

    /** 规格名称 */
    private String specName;

    /** 条码 */
    private String barcode;

    /** 数量（精确到小数点后2位） */
    private BigDecimal sellCount;

    /** 单位 */
    private String unit;

    /** 单价（精确到小数点后2位） */
    private BigDecimal sellPrice;

    /** 总金额（精确到小数点后2位） */
    private BigDecimal sellTotal;

    /** 货品成本（精确到小数点后2位） */
    private BigDecimal cost;

    /** 抵扣金额（精确到小数点后2位） */
    private BigDecimal discountTotal;

    /** 抵扣积分 */
    private Integer discountPoint;

    /** 税额（精确到小数点后2位） */
    private BigDecimal taxFee;

    /** 分摊金额（精确到小数点后2位） */
    private BigDecimal shareFavourableFee;

    /** 预估重量（精确到小数点后2位） */
    private BigDecimal estimateWeight;

    /** 货品备注 */
    private String goodsMemo;

    /** 货品分类 */
    private String cateName;

    /** 品牌 */
    private String brandName;

    /** 货品标签 */
    private String goodsTags;

    /** 组合装标记（0:否 1:是） */
    private Integer isFit;

    /** 赠品标记（0:否 1:是） */
    private Integer isGift;

    /** 优惠（精确到小数点后2位） */
    private BigDecimal discountFee;

    /** 税率（精确到小数点后4位） */
    private BigDecimal taxRate;

    /** 预估体积（单个货品，精确到小数点后4位） */
    private BigDecimal estimateGoodsVolume;

    /** 是否预售货品标记（0:否 1:是） */
    private Integer isPresell;

    /** 终端销售单价（精确到小数点后2位） */
    private BigDecimal customerPrice;

    /** 终端销售金额（精确到小数点后2位） */
    private BigDecimal customerTotal;

    /** 交易编号 */
    private String tradeGoodsNo;

    /** 交易名称 */
    private String tradeGoodsName;

    /** 交易规格 */
    private String tradeGoodsSpec;

    /** 交易单位 */
    private String tradeGoodsUnit;

    /** 网店子订单号 */
    private String sourceSubtradeNo;

    /** 平台代码 */
    private String platCode;

    /** 平台商品id */
    private String platGoodsId;

    /** 商品明细id（唯一标识） */
    private String subTradeId;

    /**
     *
     * 货品发货批次明细
     */
    private List<GoodsDelivery> goodsDelivery;
}
