package com.elitesland.zhiyuan.openapi.outer.jackyun.data.websocketdto;

/**
 * 处理服务端推送来的消息成功后回调服务端 应答失败的dto
 *
 * @author hup
 * @data 2020-06-02 10:37
 **/
public class DealFailAndCallBackResponseDto {
    /**
     * 失败消息类型常量
     */
    private static final String CONTENT_TYPE = "THIRD_PART_FAIL";

    /**
     * 构造函数
     */
    public DealFailAndCallBackResponseDto() {
        this.contentType = CONTENT_TYPE;
    }

    /**
     * 构造函数
     *
     * @param messageId 服务端消息ID
     */
    public DealFailAndCallBackResponseDto(String messageId) {
        this.messageId = messageId;
        this.contentType = CONTENT_TYPE;
    }

    /**
     * 消息类型
     */
    private String contentType;
    /**
     * 服务端消息ID
     */
    private String messageId;

    public String getContentType() {
        return contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getMessageId() {
        return messageId;
    }

    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }
}
