package com.elitesland.zhiyuan.openapi.outer.jushuitan.params.req;

import lombok.Data;

/**
 * 聚水潭出入库结果明细查询请求参数
 * API: jushuitan.inoutresult.inoutresultdetail.query
 */
@Data
public class InOutResultDetailQueryRequest {

    /**
     * 页大小（1-500）
     */
    private Integer page_size = 500;

    /**
     * id必传。第一次查询时，如果不知道最小id是多少，可传0，获取第一批数据。
     * 后续查询，id=前一批数据最后一条数据的id+1，通过该新id查询接口，获取到新一批数据
     */
    private Long id;

    /**
     * 时间类型。
     * 单据时间 0； 更新时间 1; 金额核销时间：2； 金额核销系统时间：bc_operate_date 3;
     * 数量核销时间：4； 数量核销系统时间：qty_check_operate_date 5；记账时间：amountcheck_accounting_date 6 ;妥投记账时间 7
     */
    private Integer time_type;

    /**
     * 开始时间
     */
    private String begin_date;

    /**
     * 结束时间
     */
    private String end_date;

    /**
     * 店铺。如果想按分销商查询数据，可将分销商商家编码*（-1）作为店铺入参。多个值逗号分隔
     */
    private String shop_id;

    /**
     * 单号。多个值逗号分隔
     */
    private String code;

    /**
     * 单号类型。时间戳：id（page_index始终传1）; 原始线上单号：item_so_id ;出入库单号：io_id; 出入库子单号：ioi_id ;售后单号：as_id
     */
    private String code_type;

    /**
     * 实际出入库,虚拟单据来源：（可传多个）
     * 实际出入库、虚拟、核销、销售出仓、调整数量、调整发出余额、销售退货、无出入库单出库、无出入库单退货、无出入库单换货、手动调整-调整数量、手动调整-调整发出余额、手动调整-核销、销售退款、换货
     */
    private String bill_type;

    /**
     * 单据类型：销售出仓、销售退货、销售退款、换货、无出入库单出库、无出入库单退货、无出入库单换货、无信息件、自动调整、手动调整、收款（仅到账版有）、妥投（仅妥投版有）。多个值逗号分隔
     */
    private String bill_detail_type;

    /**
     * 单据属性： 正常单据：0 ； 历史单据：1 ； 正常单据结账后变更单据：2 ； 历史单据结账后变更单据：3 ； 全部：null。多个值逗号分隔
     */
    private String bill_flag;

    /**
     * 特殊标签
     */
    private String situation;

    /**
     * 金额核销方式，自动核销（有账单）：AutoCheck：0；手工核销（有账单）：UserCheck：1；手工调整（无账单）：UserAdjustment：2，未核销Null：3;无明细核销（有账单）：4；强制核销：5）收入调整-有货款核销：6，收入调整-无货款有应收核销：7，收入调整-无货款无明细核销：8。多个值逗号分隔
     */
    private String check_way;

    /**
     * 数量核销方式：自动核销：0；手动核销：1；未核销：2。多个值逗号分隔
     */
    private String qty_check_way;

    /**
     * 发出商品核销方式：自动核销：0；手动核销：1；未核销：2。多个值逗号分隔
     */
    private String sentgoods_check_way;

    /**
     * 结账状态：未结账：0；已结账：1；全部：null
     */
    private Integer is_settle;

    /**
     * 删除标识：未删除：0；已删除：1；不传默认为0。多个值逗号分隔
     */
    private String del_flag;

    /**
     * 是否查询洗数完成：true：是；false：否；不传默认为false
     */
    private Boolean is_check_washfinished;

    /**
     * 仅退款调整结果：用户在仅退款追踪表调整反写的标签；涉及：仅退款、待退货、快递赔付、用户自定义标签等
     */
    private String onlyrefund_approve_result;

    /**
     * 仅退款调整时间：用户在仅退款追踪表调整时反写的时间
     */
    private String onlyrefund_approve_date;

    /**
     * 组合装商品编码
     */
    private String combine_sku_id;

    /**
     * 妥投状态(仅妥投版有该字段)：未妥投0，已妥投1,全部null
     */
    private Integer delivered_status;
}