/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.zhiyuan.openapi.outer.jushuitan.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.zhiyuan.openapi.outer.jushuitan.common.service.JstService;
import com.elitesland.zhiyuan.openapi.outer.jushuitan.config.JstProperties;
import com.elitesland.zhiyuan.openapi.outer.jushuitan.params.req.JstTryFunDTO;
import com.elitesland.zhiyuan.openapi.outer.jushuitan.params.req.PurchaseInboundListRequest;
import com.elitesland.zhiyuan.openapi.outer.jushuitan.params.req.PurchaseInboundQueryRequest;
import com.elitesland.zhiyuan.openapi.outer.jushuitan.params.req.PurchaseReturnBatchRequest;
import com.elitesland.zhiyuan.openapi.outer.jushuitan.params.req.WarehouseQueryRequest;
import com.elitesland.zhiyuan.openapi.outer.jushuitan.params.resp.JushuitanBaseResponse;
import com.elitesland.zhiyuan.openapi.outer.jushuitan.params.resp.PurchaseInboundQueryResponse;
import com.elitesland.zhiyuan.openapi.outer.jushuitan.params.resp.PurchaseInboundResponse;
import com.elitesland.zhiyuan.openapi.outer.jushuitan.params.resp.WarehouseQueryResponse;
import com.elitesland.zhiyuan.openapi.outer.jushuitan.service.JushuitanService;
import com.elitesland.zhiyuan.openapi.outer.nc.exception.NcApiException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/jst/retry"})
@Api(value="JST\u91cd\u8bd5\u63a5\u53e3", tags={"JST\u91cd\u8bd5\u63a5\u53e3"})
public class JstRetryController {
    private static final Logger log = LoggerFactory.getLogger(JstRetryController.class);
    private final JstService jstService;
    private final JushuitanService jushuitanService;
    private final JstProperties jstProperties;

    @PostMapping(value={"/tryFun"})
    @ApiOperation(value="JST\u91cd\u8bd5\u63a5\u53e3")
    public ApiResult<JushuitanBaseResponse> tryFun(@RequestBody JstTryFunDTO jstTryFunDTO, String url) throws IOException {
        URL uri = new URL(this.jstProperties.getServerUrl() + url);
        String rspStr = this.jstService.callApi(uri, jstTryFunDTO.getParams());
        if (!StringUtils.hasText((String)rspStr)) {
            throw new NcApiException("YST\u63a5\u53e3\u8fd4\u56de\u7a7a\u54cd\u5e94");
        }
        try {
            JushuitanBaseResponse response = (JushuitanBaseResponse)JSON.parseObject((String)rspStr, JushuitanBaseResponse.class);
            if (response == null) {
                log.error("JST\u63a5\u53e3\u54cd\u5e94\u89e3\u6790\u5931\u8d25: {}", (Object)rspStr);
                return ApiResult.fail((String)"JST\u63a5\u53e3\u54cd\u5e94\u89e3\u6790\u5931\u8d25");
            }
            if (!response.isSuccess()) {
                String errorMessage = response.getMsg();
                log.error("JST\u63a5\u53e3\u8c03\u7528\u5931\u8d25: {}", (Object)errorMessage);
                return ApiResult.fail((String)errorMessage);
            }
            log.info("JST\u63a5\u53e3\u8c03\u7528\u6210\u529f");
            return ApiResult.ok((Object)response);
        }
        catch (JSONException e) {
            log.error("JST\u63a5\u53e3\u54cd\u5e94JSON\u89e3\u6790\u5931\u8d25: {}", (Object)rspStr, (Object)e);
            return ApiResult.fail((String)"JST\u63a5\u53e3\u54cd\u5e94\u683c\u5f0f\u9519\u8bef");
        }
    }

    @PostMapping(value={"/testPurchaseinCreatebatch"})
    @ApiOperation(value="JST \u91c7\u8d2d\u5165\u5e93 Test\u63a5\u53e3")
    public ApiResult<PurchaseInboundResponse> testPurchaseinCreatebatch(@RequestBody PurchaseInboundListRequest purchaseInboundListRequest, Long docId, String docNo) throws Exception {
        PurchaseInboundResponse rspStr = this.jushuitanService.purchaseinCreatebatch(purchaseInboundListRequest, docId, docNo);
        return ApiResult.ok((Object)rspStr);
    }

    @PostMapping(value={"/testWarehouseQuery"})
    @ApiOperation(value="JST \u4ed3\u5e93\u67e5\u8be2 Test\u63a5\u53e3")
    public ApiResult<WarehouseQueryResponse> testWarehouseQuery(@RequestBody(required=false) WarehouseQueryRequest warehouseQueryRequest, String pushRecordInterType, Long docId, String docNo) throws Exception {
        if (warehouseQueryRequest == null) {
            warehouseQueryRequest = new WarehouseQueryRequest();
            warehouseQueryRequest.setPage_index(1);
            warehouseQueryRequest.setPage_size(30);
        }
        if (!StringUtils.hasText((String)pushRecordInterType)) {
            pushRecordInterType = "JST_INV_WH_TO_SCM";
        }
        if (docId == null) {
            docId = 0L;
        }
        if (!StringUtils.hasText((String)docNo)) {
            docNo = "TEST_" + System.currentTimeMillis();
        }
        log.info("\u4ed3\u5e93\u67e5\u8be2\u6d4b\u8bd5\u63a5\u53e3\u8c03\u7528 - \u53c2\u6570: {}, \u63a8\u9001\u7c7b\u578b: {}, \u6587\u6863ID: {}, \u6587\u6863\u7f16\u53f7: {}", new Object[]{JSON.toJSONString((Object)warehouseQueryRequest), pushRecordInterType, docId, docNo});
        WarehouseQueryResponse response = this.jushuitanService.queryWarehouse(warehouseQueryRequest, pushRecordInterType, docId, (String)docNo);
        log.info("\u4ed3\u5e93\u67e5\u8be2\u6d4b\u8bd5\u63a5\u53e3\u54cd\u5e94 - \u72b6\u6001: {}, \u4ed3\u5e93\u6570\u91cf: {}", (Object)(response.isSuccess() ? "\u6210\u529f" : "\u5931\u8d25"), (Object)(response.getData() != null && ((WarehouseQueryResponse.WarehouseQueryData)response.getData()).getDatas() != null ? ((WarehouseQueryResponse.WarehouseQueryData)response.getData()).getDatas().size() : 0));
        return ApiResult.ok((Object)response);
    }

    @PostMapping(value={"/testPurchaseInboundQuery"})
    @ApiOperation(value="JST \u91c7\u8d2d\u5165\u5e93\u67e5\u8be2 Test\u63a5\u53e3")
    public ApiResult<PurchaseInboundQueryResponse> testPurchaseInboundQuery(@RequestBody(required=false) PurchaseInboundQueryRequest purchaseInboundQueryRequest, Long docId, String docNo) throws Exception {
        if (purchaseInboundQueryRequest == null) {
            purchaseInboundQueryRequest = new PurchaseInboundQueryRequest();
            purchaseInboundQueryRequest.setPage_index(1);
            purchaseInboundQueryRequest.setPage_size(30);
            purchaseInboundQueryRequest.setModified_begin("2024-10-01");
            purchaseInboundQueryRequest.setModified_end("2024-10-31");
        }
        if (docId == null) {
            docId = 0L;
        }
        if (!StringUtils.hasText((String)docNo)) {
            docNo = "TEST_" + System.currentTimeMillis();
        }
        log.info("\u91c7\u8d2d\u5165\u5e93\u67e5\u8be2\u6d4b\u8bd5\u63a5\u53e3\u8c03\u7528 - \u53c2\u6570: {},  \u6587\u6863ID: {}, \u6587\u6863\u7f16\u53f7: {}", new Object[]{JSON.toJSONString((Object)purchaseInboundQueryRequest), docId, docNo});
        PurchaseInboundQueryResponse response = this.jushuitanService.queryPurchaseInbound(purchaseInboundQueryRequest, docId, (String)docNo);
        log.info("\u91c7\u8d2d\u5165\u5e93\u67e5\u8be2\u6d4b\u8bd5\u63a5\u53e3\u54cd\u5e94 - \u72b6\u6001: {}, \u5165\u5e93\u5355\u6570\u91cf: {}", (Object)(response.isSuccess() ? "\u6210\u529f" : "\u5931\u8d25"), (Object)(response.getData() != null && ((PurchaseInboundQueryResponse.PurchaseInboundQueryData)response.getData()).getDatas() != null ? ((PurchaseInboundQueryResponse.PurchaseInboundQueryData)response.getData()).getDatas().size() : 0));
        return ApiResult.ok((Object)response);
    }

    @PostMapping(value={"/testPurchaseinReturnbatch"})
    @ApiOperation(value="JST \u91c7\u8d2d\u51fa\u5e93 Test\u63a5\u53e3")
    public ApiResult<PurchaseInboundResponse> testPurchaseinReturnbatch(@RequestBody PurchaseReturnBatchRequest purchaseReturnBatchRequest, Long docId, String docNo) throws Exception {
        PurchaseInboundResponse rspStr = this.jushuitanService.purchaseinReturnbatch(purchaseReturnBatchRequest, docId, docNo);
        return ApiResult.ok((Object)rspStr);
    }

    public JstRetryController(JstService jstService, JushuitanService jushuitanService, JstProperties jstProperties) {
        this.jstService = jstService;
        this.jushuitanService = jushuitanService;
        this.jstProperties = jstProperties;
    }
}

