package com.elitesland.zhiyuan.openapi.outer.jushuitan.service;

import com.elitesland.zhiyuan.openapi.outer.jggyun.params.SupplierRequest;
import com.elitesland.zhiyuan.openapi.outer.jggyun.params.UpdateGoodsRequest;
import com.elitesland.zhiyuan.openapi.outer.jushuitan.params.req.*;
import com.elitesland.zhiyuan.openapi.outer.jushuitan.params.resp.*;
import org.springframework.transaction.annotation.Transactional;

public interface JushuitanService {

    /**
     * 创建物料接口
     */
    JushuitanBaseResponse createMaterial(UpdateGoodsRequest request, String pushRecordInterType, Long docId, String docNo) throws Exception;
    /**
     * 创建物料接口
     */
    JushuitanBaseResponse createMaterial(String appKey, String appSecret, String accessToken, UpdateGoodsRequest request, String pushRecordInterType, Long docId, String docNo) throws Exception;

    /**
     * 创建供应商
     * @param request 供应商请求参数
     * @param pushRecordInterType 推送记录接口类型
     * @param docId 文档ID
     * @param docNo 文档编号
     * @return {@link SupplierSyncResponse} 供应商同步响应
     */
    SupplierSyncResponse syncSupp(SupplierRequest request, String pushRecordInterType, Long docId, String docNo) throws Exception;

    /**
     * 创建供应商
     *
     * @param appKey              应用密钥
     * @param appSecret           应用密钥
     * @param accessToken         访问令牌
     * @param request             请求
     * @param pushRecordInterType 推送记录类型
     * @param docId               文档Id
     * @param docNo               文件编号
     * @return {@link SupplierSyncResponse }
     * @throws Exception 例外
     */
    SupplierSyncResponse syncSupp(String appKey, String appSecret, String accessToken, SupplierRequest request, String pushRecordInterType, Long docId, String docNo) throws Exception;

    /**
     * 生成采购入库单
     *
     * @param request 请求
     * @param docId   文档Id
     * @param docNo   文档编号
     * @return {@link PurchaseInboundResponse }
     * @throws Exception 例外
     */
    PurchaseInboundResponse purchaseinCreatebatch(PurchaseInboundListRequest request, Long docId, String docNo) throws Exception;


    @Transactional
    PurchaseInboundResponse purchaseinCreatebatch(String appKey, String appSecret, String accessToken, PurchaseInboundListRequest request, Long docId, String docNo) throws Exception;

    /**
     * 查询仓库列表
     *
     * @param request 仓库查询请求参数
     * @param pushRecordInterType 推送记录接口类型
     * @param docId 文档ID
     * @param docNo 文档编号
     * @return {@link WarehouseQueryResponse} 仓库查询响应
     * @throws Exception 例外
     */
    WarehouseQueryResponse queryWarehouse(WarehouseQueryRequest request, String pushRecordInterType, Long docId, String docNo) throws Exception;

    /**
     * 查询仓库列表
     *
     * @param appKey              应用密钥
     * @param appSecret           应用密钥
     * @param accessToken         访问令牌
     * @param request             请求
     * @param pushRecordInterType 推送记录类型
     * @param docId               文档Id
     * @param docNo               文件编号
     * @return {@link WarehouseQueryResponse }
     * @throws Exception 例外
     */
    WarehouseQueryResponse queryWarehouse(String appKey, String appSecret, String accessToken, WarehouseQueryRequest request, String pushRecordInterType, Long docId, String docNo) throws Exception;

    /**
     * 查询采购入库单
     *
     * @param request 采购入库查询请求参数
     * @param docId 文档ID
     * @param docNo 文档编号
     * @return {@link PurchaseInboundQueryResponse} 采购入库查询响应
     * @throws Exception 例外
     */
    PurchaseInboundQueryResponse queryPurchaseInbound(PurchaseInboundQueryRequest request, Long docId, String docNo) throws Exception;

    /**
     * 查询采购入库单
     *
     * @param appKey      应用密钥
     * @param appSecret   应用密钥
     * @param accessToken 访问令牌
     * @param request     请求
     * @param docId       文档Id
     * @param docNo       文件编号
     * @return {@link PurchaseInboundQueryResponse }
     * @throws Exception 例外
     */
    PurchaseInboundQueryResponse queryPurchaseInbound(String appKey, String appSecret, String accessToken, PurchaseInboundQueryRequest request, Long docId, String docNo) throws Exception;


    PurchaseInboundResponse purchaseinReturnbatch(PurchaseReturnBatchRequest request, Long docId, String docNo) throws Exception;



    /**
     * 生成采购出库单
     *
     * @param appKey      应用密钥
     * @param appSecret   应用密钥
     * @param accessToken 访问令牌
     * @param request     请求
     * @param docId       文档Id
     * @param docNo       文件编号
     * @return {@link PurchaseInboundResponse }
     * @throws Exception 例外
     */
    @Transactional
    PurchaseInboundResponse purchaseinReturnbatch(String appKey, String appSecret, String accessToken, PurchaseReturnBatchRequest request, Long docId, String docNo) throws Exception;




    /**
     * 查询采购出库单
     *
     * @param request 采购入库查询请求参数
     * @param docId 文档ID
     * @param docNo 文档编号
     * @return {@link PurchaseInboundQueryResponse} 采购入库查询响应
     * @throws Exception 例外
     */
    PurchaseOnboundQueryResponse queryPurchaseOnbound(PurchaseInboundQueryRequest request, Long docId, String docNo) throws Exception;

    /**
     * 查询采购出库单
     *
     * @param appKey      应用密钥
     * @param appSecret   应用密钥
     * @param accessToken 访问令牌
     * @param request     请求
     * @param docId       文档Id
     * @param docNo       文件编号
     * @return {@link PurchaseInboundQueryResponse }
     * @throws Exception 例外
     */
    PurchaseOnboundQueryResponse queryPurchaseOnbound(String appKey, String appSecret, String accessToken, PurchaseInboundQueryRequest request, Long docId, String docNo) throws Exception;

    /**
     * 库存调拨上传（跨仓调拨）
     *
     * @param request 调拨上传请求参数
     * @param docId 文档ID
     * @param docNo 文档编号
     * @return {@link AllocateUploadResponse} 调拨上传响应
     * @throws Exception 例外
     */
    AllocateUploadResponse allocateUpload(AllocateUploadRequest request, Long docId, String docNo) throws Exception;

    /**
     * 库存调拨上传（跨仓调拨）
     *
     * @param appKey      应用密钥
     * @param appSecret   应用密钥
     * @param accessToken 访问令牌
     * @param request     请求
     * @param docId       文档Id
     * @param docNo       文件编号
     * @return {@link AllocateUploadResponse }
     * @throws Exception 例外
     */
    AllocateUploadResponse allocateUpload(String appKey, String appSecret, String accessToken, AllocateUploadRequest request, Long docId, String docNo) throws Exception;



    /**
     * 库存调拨上传（跨仓调拨）出查询
     *
     * @param request 出查询
     * @param docId 文档ID
     * @param docNo 文档编号
     * @return {@link AllocateUploadResponse} 调拨上传响应
     * @throws Exception 例外
     */
    PurchAllotResultDetailQueryResponse queryAllotPurchaseOnbound(PurchaseInAllotQueryRequest request, Long docId, String docNo) throws Exception;

    /**
     * 库存调拨上传（跨仓调拨）出查询
     *
     * @param appKey      应用密钥
     * @param appSecret   应用密钥
     * @param accessToken 访问令牌
     * @param request     请求
     * @param docId       文档Id
     * @param docNo       文件编号
     * @return {@link AllocateUploadResponse }
     * @throws Exception 例外
     */
    PurchAllotResultDetailQueryResponse queryAllotPurchaseOnbound(String appKey, String appSecret, String accessToken, PurchaseInAllotQueryRequest request, Long docId, String docNo) throws Exception;



    /**
     * 库存调拨上传（跨仓调拨）入查询
     *
     * @param request 出查询
     * @param docId 文档ID
     * @param docNo 文档编号
     * @return {@link AllocateUploadResponse} 调拨上传响应
     * @throws Exception 例外
     */
    PurchAllotResultDetailQueryResponse queryAllotPurchaseInbound(PurchaseInAllotQueryRequest request, Long docId, String docNo) throws Exception;

    /**
     * 库存调拨上传（跨仓调拨）入查询
     *
     * @param appKey      应用密钥
     * @param appSecret   应用密钥
     * @param accessToken 访问令牌
     * @param request     请求
     * @param docId       文档Id
     * @param docNo       文件编号
     * @return {@link AllocateUploadResponse }
     * @throws Exception 例外
     */
    PurchAllotResultDetailQueryResponse queryAllotPurchaseInbound(String appKey, String appSecret, String accessToken, PurchaseInAllotQueryRequest request, Long docId, String docNo) throws Exception;

}