package com.elitesland.zhiyuan.openapi.outer.nc.constants;

import lombok.Getter;

/**
 * 动作编码枚举
 * 单据动作
平台提供一些标准的单据动作，另外一些以DEF开头的动作编码为自定义开发的单据动作。
平台也支持单据动作的组合，比如单据动作WRITE@APPROVE代表保存并审核，组合动作的规则是使用@符号分割单据动作。
 *
 * @author duwh
 */
@Getter
public enum NcActionCodeEnum {

    /**
     * 查询
     */
    QUERY("QUERY", "查询"),

    /**
     * 保存
     */
    WRITE("WRITE", "保存"),

    /**
     * 审批
     */
    APPROVE("APPROVE", "审批"),

    /**
     * 弃审
     */
    UNAPPROVE("UNAPPROVE", "弃审");

    private final String code;
    private final String name;

    NcActionCodeEnum(String code, String name) {
        this.code = code;
        this.name = name;
    }
}