package com.elitesland.zhiyuan.openapi.outer.jushuitan.params.resp;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * ClassName: SupplierSyncResponse
 * Description: 供应商同步响应参数
 *
 * @author system
 * @date 2024/10/28
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class SupplierSyncResponse extends JushuitanBaseResponse<SupplierSyncResponse.SupplierSyncData> {

    /**
     * 供应商同步响应数据
     */
    @Data
    public static class SupplierSyncData {

        @ApiModelProperty("供应商数据列表")
        private List<SupplierData> datas;

        @ApiModelProperty("页码")
        private Integer page_index;

        @ApiModelProperty("是否有下一页")
        private Boolean has_next;

        @ApiModelProperty("数据总数")
        private Integer data_count;

        @ApiModelProperty("总页数")
        private Integer page_count;

        @ApiModelProperty("每页大小")
        private Integer page_size;
    }

    /**
     * 供应商数据
     */
    @Data
    public static class SupplierData {

        @ApiModelProperty("返回消息")
        private String msg;

        @ApiModelProperty("是否成功")
        private Boolean issuccess;

        @ApiModelProperty("供应商名称")
        private String name;

        @ApiModelProperty("供应商ID")
        private Integer id;

        @ApiModelProperty("供应商编码")
        private String supplier_code;
    }
}