package com.elitesland.zhiyuan.openapi.outer.jushuitan.demo;// 库存调拨上传接口使用示例
import com.elitesland.zhiyuan.openapi.outer.jushuitan.params.req.AllocateUploadRequest;
import com.elitesland.zhiyuan.openapi.outer.jushuitan.params.resp.AllocateUploadResponse;
import com.elitesland.zhiyuan.openapi.outer.jushuitan.service.JushuitanService;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;

public class AllocateUploadExample {
    
    private JushuitanService jushuitanService;
    
    public void uploadAllocateExample() throws Exception {
        // 构建调拨单请求
        AllocateUploadRequest request = new AllocateUploadRequest();
        
        // 创建调拨单项
        AllocateUploadRequest.AllocateItem allocateItem = new AllocateUploadRequest.AllocateItem();
        allocateItem.setSo_id("21120211072883513540"); // 外部订单号
        allocateItem.setIo_date("2024-11-06"); // 单据日期
        allocateItem.setPrice(new BigDecimal("100.00")); // 金额
        allocateItem.setGo_co_id(1); // 调出仓公司id
        allocateItem.setWarehouse(2); // 调出仓库id（销退仓）
        allocateItem.setLink_co_id(2); // 调入仓公司id
        allocateItem.setLink_warehouse(4); // 调入仓库id（次品仓）
        allocateItem.setRemark("测试跨仓调拨"); // 备注
        allocateItem.setIs_confirm(true); // 自动完成单据
        allocateItem.setIs_confirming(false); // 不自动确认
        allocateItem.setLabels(Arrays.asList("1", "2")); // 标签
        
        // 创建商品明细
        AllocateUploadRequest.AllocateItemDetail itemDetail = new AllocateUploadRequest.AllocateItemDetail();
        itemDetail.setSku_id("sn2"); // 商品编码
        itemDetail.setQty(2); // 数量
        itemDetail.setBatch_id(""); // 批次号
        itemDetail.setProduced_date(""); // 生产日期
        itemDetail.setExpiration_date(""); // 有效期
        
        allocateItem.setItems(Collections.singletonList(itemDetail));
        request.setList(Collections.singletonList(allocateItem));
        
        // 调用接口
        AllocateUploadResponse response = jushuitanService.allocateUpload(request, 123L, "DOC001");
        
        // 处理响应
        if (response.isSuccess()) {
            System.out.println("调拨单上传成功");
            if (response.getData() != null && response.getData().getDatas() != null) {
                for (AllocateUploadResponse.AllocateData data : response.getData().getDatas()) {
                    System.out.println("线上订单号: " + data.getSo_id());
                    System.out.println("调拨出单号: " + data.getIo_id());
                    if (data.getAllocateIn_io_id() != null) {
                        System.out.println("调拨入单号: " + data.getAllocateIn_io_id());
                    }
                }
            }
        } else {
            System.out.println("调拨单上传失败: " + response.getMsg());
        }
    }
}