package com.elitesland.zhiyuan.openapi.outer.jushuitan.params.req;

import lombok.Data;

import java.util.List;

/**
 * 聚水潭采购出库请求参数
 */
@Data
public class PurchaseReturnRequest {
    private Integer po_id; // 采购单id（当此值大于0且type为0时将强制修改type为1）
    private String receiver_city; // 收件人城市
    private String receiver_district; // 收件人区
    private Integer type; // 退货类型(0：普通退货，1：质检退货，2：返修退货)
    private String external_id; // 外部采购退货单单号(必填)
    private String remark; // 备注
    private Integer warehouse; // 仓库编号(主仓=1，销退仓=2，进货仓=3，次品仓=4，自定义仓=6-15)
    private Integer receiver_mobile; // 收件电话
    private String receiver_state; // 收件人省
    private Integer wms_co_id; // 仓储方id（分仓或者老版三方仓）
    private Boolean is_confirm; // 是否审核
    private String receiver_address; // 收件人地址
    private Integer supplier_id; // 供应商id(必填)
    private List<PurchaseReturnItemRequest> items; // 商品列表(必填)
    @Data
    public static class PurchaseReturnItemRequest {
        private String batch_id; // 批次单号
        private Double price; // 单价
        private Integer qty; // 数量(必填)
        private String sku_id; // 商品编码(必填)
        private List<String> sku_sn; // 唯一码集合
        private String remark; // 明细备注
        private String produced_date; // 生产日期

    }

}
