package com.elitesland.zhiyuan.openapi.outer.jushuitan.params.resp;

import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;
import java.util.List;

/**
 * 聚水潭调拨单查询结果
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class PurchAllotResultDetailQueryResponse extends JushuitanBaseResponse {

    /**
     * 响应数据
     */
    private AllocateQueryData data;
    @Data
    public static class AllocateQueryData {
        /**
         * 调拨单数据列表
         */
        private List<IoBill> datas;
    }
    @Data
    public static class IoBill {
        private Integer wms_co_id;
        private Integer co_id;
        private Integer io_id;
        private String io_date;
        private String modified;
        private String status;
        private String warehouse;
        private String link_warehouse;
        private String f_status;
        private String type;
        private Integer wh_id;
        private Integer link_wh_id;
        private Integer link_wms_co_id;
        private Integer link_io_id;
        private String so_id;
        private String wave_id;
        private String remark;
        private String creator_name;
        private String lock_wh_id;
        private String lock_link_wh_id;
        private String out_io_id;
        private List<String> labels;
        private List<IoBillItem> items;
        private List<Batch> batchs;
        private List<Sns> sns;
        private String receiver_name_en;
        private String receiver_mobile_en;
        private String receiver_state;
        private String receiver_city;
        private String receiver_district;
        private String receiver_address;
        private String l_id;
        private String lc_id;
        private String logistics_company;
        private String unit;
    }
    @Data
    public static class IoBillItem {
        private Integer io_id;
        private Integer ioi_id;
        private String sku_id;
        private String i_id;
        private Integer qty;
        private Double cost_price;
        private Double cost_amount;
        private String name;
        private String properties_value;
        private Integer r_qty;
        private String batch_id;
        private String product_date;
        private Integer supplier_id;
        private String expiration_date;
    }

    @Data
    public static class Sns {
        private String sku_id;
        private String sn;
    }

    @Data
    public static class Batch {
        private String batch_no;
        private String sku_id;
        private Integer qty;
        private String product_date;
        private Integer supplier_id;
        private String supplier_name;
    }
}
