package com.elitesland.zhiyuan.openapi.outer.nc.client;

import com.dtflys.forest.annotation.*;
import com.dtflys.forest.http.ForestResponse;
import com.elitesland.nc.interceptor.NcForestInterceptor;
import com.elitesland.zhiyuan.openapi.outer.nc.dto.NcRequestDTO;

/**
 * NC接口Forest客户端
 *
 * @author duwh
 */
@BaseRequest(
    baseURL = "${nc.uri}",
    contentType = "application/json",
    timeout = 30000,
    interceptor = NcForestInterceptor.class
)
public interface NcForestClient {

    /**
     * 调用NC数据接口 - 手动设置URL参数
     *
     * @param appId NC应用ID
     * @param from 来源系统
     * @param usercode 用户编码
     * @param timestamp 时间戳
     * @param token 签名token
     * @param request 请求数据
     * @return 响应结果
     */
    @Post("/service/muap/api")
    ForestResponse<String> callNcDataApiWithParams(
            @Var("appId") String appId,
            @Var("from") String from,
            @Var("usercode") String usercode,
            @Var("timestamp") String timestamp,
            @Var("token") String token,
            @Body NcRequestDTO request
    );

    /**
     * 调用NC数据接口 - 使用拦截器自动设置URL参数
     */
    @Post("/service/muap/api")
    String callNcApi(@Body NcRequestDTO request);
}