package com.elitesland.zhiyuan.openapi.outer.jushuitan.params.resp;

import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 库存调拨上传响应
 * API: /open/allocate/kc/upload
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class AllocateUploadResponse extends JushuitanBaseResponse {

    /**
     * 响应数据
     */
    private AllocateUploadData data;

    @Data
    public static class AllocateUploadData {
        /**
         * 调拨单数据列表
         */
        private List<AllocateData> datas;
    }

    @Data
    public static class AllocateData {
        /**
         * 线上订单号
         */
        private String so_id;

        /**
         * 调拨出单号
         */
        private String io_id;

        /**
         * 调拨入单号（如is_confirm传true返回）
         */
        private String allocateIn_io_id;
    }
}