package com.elitesland.zhiyuan.openapi.outer.jackyun.data.bizdata.erp.erpallocateQuery;

import com.elitesland.zhiyuan.openapi.outer.jackyun.data.bizdata.core.BaseRequestBizData;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

@Data
public class ErpStockAllocateQueryReponseBizData extends BaseRequestBizData {
    private String reason;                  // 调拨原因
    private String companyName;             // 公司名称
    private String outWarehouseName;        // 调出仓库名
    private String memo;                    // 调拨单备注
    private Integer inStatus;               // 入库状态
    private String operator;                // 制单人
    private String outWarehouseId;          // 调出仓库ID（String防溢出！）
    private List<StockAllocateDetailView> stockAllocateDetailViews; // 明细列表
    private String allocatePriceType;       // 价格类型
    private String isAllocateDifferentCompany; // 是否跨公司（1/0）
    private String flagData;                // 标记ID集合
    private String operatorId;              // 制单人ID
    private StockAllocateExpressInfo stockAllocateExpressInfo; // 物流信息
    private BigDecimal skuCount;            // 货品数量
    private String sourceNo;                // 来源单号
    private String applyDepartId;           // 申请部门ID
    private String applyUserName;           // 申请人
    private BigDecimal totalAmount;         // 总金额
    private BigDecimal goodsCount;          // 货品种类
    private String companyId;               // 公司ID
    private String auditUserId;             // 审核人ID
    private String auditUserName;           // 审核人
    private String allocateId;              // 调拨单ID
    private String status;                  // 审核状态
    private String logisticNo;              // 物流单号
    private String gmtModified;             // 修改时间（时间戳字符串）
    private String applyUserId;             // 申请人ID
    private String isNegativeStock;         // 是否负库存
    private String inWarehouseId;           // 调入仓库ID
    private String allocateNo;              // 调拨单号
    private String planOutDate;             // 预计出库时间
    private String auditDate;               // 审核时间
    private String outWarehouseCode;        // 调出仓库编号
    private String intWarehouseName;        // 调入仓库名
    private String gmtCreate;               // 创建时间
    private String allocatePrice;           // 价格类型
    private String applyDepartName;         // 申请部门
    private String intWarehouseCode;        // 调入仓库编号
    private Integer allocateType;           // 调拨类型
    private Integer outStatus;              // 出库状态
    private String applyDate;               // 申请时间
    private String planInDate;              // 预计入库时间

    @Data
    public static class StockAllocateDetailView {
        private BigDecimal skuPrice;            // 单价
        private String outSkuCode;              // 外部货品ID
        private String goodsName;               // 货品名称
        private String skuId;                   // SKU ID
        private BigDecimal skuCount;            // 数量
        private String unitName;                // 计量单位
        private String isCertified;             // 是否正品
        private String rowRemark;               // 明细备注
        private BigDecimal totalAmount;         // 明细总金额
        private String allocateId;              // 调拨单ID
        private String goodsId;                 // 货品ID
        private String skuName;                 // SKU名称
        private String allocateDetailId;        // 明细ID
        private BigDecimal outCount;            // 已出库数量
        private List<Batch> batchList;          // 批次列表
        private String goodsNo;                 // 商品编号
        private String assistUnit;              // 辅助单位
        private BigDecimal inCount;             // 已入库数量
        private String skuBarcode;              // 条形码
        private List<Serial> serialList;        // 序列列表


    }

    // 批次信息（每个明细的批次）
    @Data
    public static class Batch {
        private String batchNo;                 // 批次号
        private String batchId;                 // 批次ID
        private String detailId;                // 明细ID
        private BigDecimal quantity;            // 批次数量
        private String batchMemo;               // 批次备注
        private BigDecimal shelfLife;           // 质保期
        private String shelfLiftUnit;           // 质保期单位（天/月）
        private String expirationDate;          // 到期日期
        private String productionDate;          // 生产日期
        private BigDecimal residueQuantity;     // 可用数量

    }

    // 序列信息（每个明细的序列码）
    @Data
    public  static class Serial {
        private String detailId;                // 明细ID
        private String caseNumber;              // 外部箱码
        private String isUsed;                  // 是否被使用
        private String serialNo;                // 唯一码
        private String snDefine1;               // 自定义字段1
        private String snDefine2;               // 自定义字段2
        private String snDefine3;               // 自定义字段3
        private String snDefine4;               // 自定义字段4
        private String snDefine5;               // 自定义字段5
        private BigDecimal cuPrice;             // 单价
    }

    // 物流信息（收发货人）
    @Data
    public static class StockAllocateExpressInfo {
        private String relDataNo;               // 关联单号
        private String sendCompanyName;         // 发件公司
        private String send;                    // 发件人
        private String sendTel;                 // 发件人电话
        private String sendPhone;               // 发件人手机
        private String sendEmail;               // 发件人邮箱
        private String sendCountryName;         // 发件人国家
        private String sendProvinceName;        // 发件人省
        private String sendCityName;            // 发件人市
        private String sendTownName;            // 发件人区
        private String sendStreetName;          // 发件人街道
        private String sendAddress;             // 发件人地址
        private String receiveCompanyName;      // 收件公司
        private String receive;                 // 收件人
        private String receiveTel;              // 收件人电话
        private String receivePhone;            // 收件人手机
        private String receiveEmail;            // 收件人邮箱
        private String receiveCountryName;      // 收件人国家
        private String receiveProvinceName;     // 收件人省
        private String receiveCityName;         // 收件人市
        private String receiveTownName;         // 收件人区
        private String receiveStreetName;       // 收件人街道
        private String receiveAddress;          // 收件人地址
        private String logisticNo;              // 物流单号

    }
}
